/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.BeanFactory;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBeanFactory
implements BeanFactory {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Object newInstance(Class<?> klass, BeanConfig config) throws ConfigurationException {
        String cname = config.getClassName();
        try {
            Class<?> objectClass = Class.forName(cname, true, config.getClassLoader());
            if (!klass.isAssignableFrom(objectClass)) {
                throw new ConfigurationException("Configured class " + cname + " does not implement " + klass.getName() + ". Please fix the repository configuration.");
            }
            if (objectClass.getAnnotation(Deprecated.class) != null) {
                this.log.warn("{} has been deprecated", (Object)cname);
            }
            return objectClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Configured bean implementation class " + cname + " was not found.", (Exception)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Configured bean implementation class " + cname + " can not be instantiated.", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Configured bean implementation class " + cname + " is protected.", (Exception)e);
        }
    }
}

