/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authentication.token;

import java.util.Date;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.jackrabbit.core.security.authentication.token.CompatTokenProvider;
import org.apache.jackrabbit.core.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.core.security.authentication.token.TokenProvider;
import org.gradle.internal.classpath.Instrumented;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBasedAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(TokenBasedAuthentication.class);
    public static final long TOKEN_EXPIRATION = 0x6DDD00L;
    public static final String TOKEN_ATTRIBUTE = ".token";
    public static final String PARAM_COMPAT = "TokenCompatMode";
    private final TokenInfo tokenInfo;

    public TokenBasedAuthentication(String token, long tokenExpiration, Session session) throws RepositoryException {
        this.tokenInfo = TokenBasedAuthentication.compatMode() ? new CompatTokenProvider((SessionImpl)session, tokenExpiration).getTokenInfo(token) : new TokenProvider((SessionImpl)session, tokenExpiration).getTokenInfo(token);
    }

    @Override
    public boolean canHandle(Credentials credentials) {
        return this.tokenInfo != null && TokenBasedAuthentication.isTokenBasedLogin(credentials);
    }

    @Override
    public boolean authenticate(Credentials credentials) throws RepositoryException {
        if (!(credentials instanceof TokenCredentials)) {
            throw new RepositoryException("TokenCredentials expected. Cannot handle " + credentials.getClass().getName());
        }
        TokenCredentials tokenCredentials = (TokenCredentials)credentials;
        return this.validateCredentials(tokenCredentials);
    }

    private boolean validateCredentials(TokenCredentials tokenCredentials) throws RepositoryException {
        if (this.tokenInfo == null) {
            log.debug("No valid TokenInfo for token.");
            return false;
        }
        long loginTime = new Date().getTime();
        if (this.tokenInfo.isExpired(loginTime)) {
            log.debug("Token is expired");
            this.tokenInfo.remove();
            return false;
        }
        if (this.tokenInfo.matches(tokenCredentials)) {
            this.tokenInfo.resetExpiration(loginTime);
            return true;
        }
        return false;
    }

    public static boolean isTokenBasedLogin(Credentials credentials) {
        return credentials instanceof TokenCredentials;
    }

    public static boolean isMandatoryAttribute(String attributeName) {
        if (TokenBasedAuthentication.compatMode()) {
            return CompatTokenProvider.isMandatoryAttribute(attributeName);
        }
        return TokenProvider.isMandatoryAttribute(attributeName);
    }

    public static boolean doCreateToken(Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            Object attr = ((SimpleCredentials)credentials).getAttribute(TOKEN_ATTRIBUTE);
            return attr != null && "".equals(attr.toString());
        }
        return false;
    }

    public static Credentials createToken(User user, SimpleCredentials credentials, long tokenExpiration, Session session) throws RepositoryException {
        String workspaceName = session.getWorkspace().getName();
        if (user == null) {
            throw new RepositoryException("Cannot create login token: No corresponding node for 'null' user in workspace '" + workspaceName + "'.");
        }
        TokenInfo ti = TokenBasedAuthentication.compatMode() ? new CompatTokenProvider((SessionImpl)session, tokenExpiration).createToken(user, credentials) : new TokenProvider((SessionImpl)session, tokenExpiration).createToken(user, credentials);
        if (ti != null) {
            return ti.getCredentials();
        }
        throw new RepositoryException("Cannot create login token.");
    }

    public static Node getTokenNode(TokenCredentials credentials, Session session) throws RepositoryException {
        if (TokenBasedAuthentication.compatMode()) {
            return CompatTokenProvider.getTokenNode(credentials.getToken(), session);
        }
        return TokenProvider.getTokenNode(credentials.getToken(), session);
    }

    public static String getUserId(TokenCredentials tokenCredentials, Session session) throws RepositoryException {
        if (TokenBasedAuthentication.compatMode()) {
            return CompatTokenProvider.getUserId(tokenCredentials, session);
        }
        if (!(session instanceof JackrabbitSession)) {
            throw new RepositoryException("JackrabbitSession expected");
        }
        NodeImpl n = (NodeImpl)TokenBasedAuthentication.getTokenNode(tokenCredentials, session);
        return TokenProvider.getUserId(n, ((JackrabbitSession)session).getUserManager());
    }

    private static boolean compatMode() {
        return Boolean.parseBoolean(Instrumented.systemProperty((String)PARAM_COMPAT, (String)"org.apache.jackrabbit.core.security.authentication.token.TokenBasedAuthentication"));
    }
}

