/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.comment.model;

import java.util.Date;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.comment.model.CommentId;
import org.silverpeas.core.contribution.model.SilverpeasContent;

public class Comment
implements SilverpeasContent {
    private static final long serialVersionUID = 3738544756345055840L;
    public static final String CONTRIBUTION_TYPE = "Comment";
    private CommentId id;
    private String resourceType;
    private ResourceReference resource;
    private String message;
    private Date creationDate;
    private Date updateDate;
    private String authorId;

    public Comment(CommentId id, String authorId, String resourceType, ResourceReference resource, Date creationDate) {
        this.id = id;
        this.resourceType = resourceType;
        this.resource = resource;
        this.authorId = authorId;
        this.creationDate = creationDate;
        this.updateDate = creationDate;
    }

    public CommentId getIdentifier() {
        return this.id;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResourceReference getResourceReference() {
        return this.resource;
    }

    public String getCreatorId() {
        return this.authorId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getCreationDate() {
        return this.creationDate == null ? new Date() : new Date(this.creationDate.getTime());
    }

    public void setLastUpdateDate(Date modificationDate) {
        if (modificationDate != null) {
            this.updateDate = new Date(modificationDate.getTime());
        }
    }

    public Date getLastUpdateDate() {
        return this.updateDate;
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public User getCreator() {
        return User.getById((String)String.valueOf(this.authorId));
    }

    public String getTitle() {
        return "";
    }

    public String getDescription() {
        return "";
    }

    public String getId() {
        return this.id.getLocalId();
    }

    public String getComponentInstanceId() {
        return this.id.getComponentInstanceId();
    }

    public String getContributionType() {
        return CONTRIBUTION_TYPE;
    }
}

