/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.silverpeas.components.kmelia.model.KmaxRuntimeException;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodePath;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;

public abstract class AbstractKmeliaUserNotification<T>
extends AbstractTemplateUserNotificationBuilder<T> {
    public AbstractKmeliaUserNotification(T resource) {
        super(resource);
    }

    protected String getLocalizationBundlePath() {
        return "org.silverpeas.kmelia.multilang.kmeliaBundle";
    }

    protected String getTemplatePath() {
        return "kmelia";
    }

    protected OrganizationController getOrganisationController() {
        return OrganizationControllerProvider.getOrganisationController();
    }

    protected NodeService getNodeService() {
        return NodeService.get();
    }

    protected NodeDetail getNodeHeader(NodePK pk) {
        NodeDetail nodeDetail;
        try {
            nodeDetail = this.getNodeService().getHeader(pk);
        }
        catch (Exception e) {
            throw new KmaxRuntimeException(e);
        }
        return nodeDetail;
    }

    protected String getHTMLNodePath(NodePK nodePK, String language) {
        Object htmlPath = "";
        if (nodePK != null) {
            htmlPath = this.getSpacesPath(nodePK.getInstanceId(), language) + this.getComponentLabel(nodePK.getInstanceId(), language);
            if (!nodePK.isRoot() && !nodePK.getId().equals("-1")) {
                NodePath path = this.getNodeService().getPath(nodePK);
                if (!path.isEmpty()) {
                    path.remove(path.size() - 1);
                }
                if (!path.isEmpty()) {
                    htmlPath = (String)htmlPath + " > " + this.displayPath((Collection<NodeDetail>)path, language);
                }
            }
        }
        return htmlPath;
    }

    private String getSpacesPath(String componentId, String language) {
        StringBuilder spacesPath = new StringBuilder();
        List spaces = this.getOrganisationController().getPathToComponent(componentId);
        for (SpaceInstLight spaceInst : spaces) {
            spacesPath.append(spaceInst.getName(language));
            spacesPath.append(" > ");
        }
        return spacesPath.toString();
    }

    private String getComponentLabel(String componentId, String language) {
        ComponentInstLight component = this.getOrganisationController().getComponentInstLight(componentId);
        String componentLabel = "";
        if (component != null) {
            componentLabel = component.getLabel(language);
        }
        return componentLabel;
    }

    private String displayPath(Collection<NodeDetail> path, String language) {
        StringBuilder pathString = new StringBuilder();
        boolean first = true;
        ArrayList<NodeDetail> pathAsList = new ArrayList<NodeDetail>(path);
        Collections.reverse(pathAsList);
        for (NodeDetail nodeInPath : pathAsList) {
            if (!first) {
                pathString.append(" > ");
            }
            first = false;
            pathString.append(nodeInPath.getName(language));
        }
        return pathString.toString();
    }
}

