/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.forums.service;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.silverpeas.components.forums.model.Forum;
import org.silverpeas.components.forums.model.ForumDetail;
import org.silverpeas.components.forums.model.ForumPK;
import org.silverpeas.components.forums.model.ForumPath;
import org.silverpeas.components.forums.model.Message;
import org.silverpeas.components.forums.model.MessagePK;
import org.silverpeas.components.forums.model.MessagePath;
import org.silverpeas.components.forums.model.Moderator;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.util.ServiceProvider;

public interface ForumService {
    public static ForumService get() {
        return (ForumService)ServiceProvider.getService(ForumService.class, (Annotation[])new Annotation[0]);
    }

    public Forum getForum(ForumPK var1);

    public ForumPath getForumPath(ForumPK var1);

    public String getForumName(int var1);

    public void deleteAll(String var1);

    public boolean isForumActive(int var1);

    public int getForumParentId(int var1);

    public String getForumInstanceId(int var1);

    public Collection<ForumDetail> getForums(Collection<ForumPK> var1);

    public ForumDetail getForumDetail(ForumPK var1);

    public Collection<Forum> getForumRootList(String var1);

    public Collection<Forum> getForumsList(Collection<ForumPK> var1);

    public Collection<Message> getThreadsList(Collection<MessagePK> var1);

    public List<Forum> getForums(ForumPK var1);

    public List<Forum> getForumsByCategory(ForumPK var1, String var2);

    public List<String> getForumSonsIds(ForumPK var1);

    public int createForum(ForumPK var1, String var2, String var3, String var4, int var5, String var6, String var7);

    public void updateForum(ForumPK var1, String var2, String var3, int var4, String var5, String var6);

    public void lockForum(ForumPK var1, int var2);

    public int unlockForum(ForumPK var1, int var2);

    public void deleteForum(ForumPK var1);

    public Collection<Message> getMessages(ForumPK var1);

    public Message getMessage(MessagePK var1);

    public MessagePath getMessagePath(MessagePK var1);

    public String getMessageTitle(int var1);

    public int getMessageParentId(int var1);

    public Message getLastMessage(ForumPK var1, String var2);

    public Message getLastMessage(ForumPK var1, int var2, String var3);

    public Message getLastMessage(ForumPK var1, List<String> var2, String var3);

    public Collection getLastMessageRSS(String var1, int var2);

    public int getNbMessages(int var1, String var2, String var3);

    public int getAuthorNbMessages(String var1, String var2);

    public int getNbResponses(int var1, int var2, String var3);

    public boolean isNewMessageByForum(String var1, ForumPK var2, String var3);

    public boolean isNewMessage(String var1, ForumPK var2, int var3, String var4);

    public void setLastVisit(String var1, int var2);

    public int createMessage(MessagePK var1, String var2, String var3, Date var4, int var5, int var6, String var7, String var8, String var9);

    public void updateMessage(MessagePK var1, String var2, String var3, String var4, String var5);

    public void updateMessageKeywords(MessagePK var1, String var2);

    public void deleteMessage(MessagePK var1);

    public boolean isModerator(String var1, ForumPK var2);

    public void addModerator(ForumPK var1, String var2);

    public void removeModerator(ForumPK var1, String var2);

    public void removeAllModerators(ForumPK var1);

    public List<Moderator> getModerators(int var1);

    public void moveMessage(MessagePK var1, ForumPK var2);

    public void subscribeMessage(MessagePK var1, String var2);

    public void unsubscribeMessage(MessagePK var1, String var2);

    public void subscribeForum(ForumPK var1, String var2);

    public void unsubscribeForum(ForumPK var1, String var2);

    public SubscriptionSubscriberList listAllSubscribers(MessagePK var1);

    public SubscriptionSubscriberList listAllSubscribers(ForumPK var1);

    public SubscriptionSubscriberList listAllSubscribers(String var1);

    public boolean isSubscriber(MessagePK var1, String var2);

    public boolean isSubscriberByInheritance(MessagePK var1, String var2);

    public boolean isSubscriber(ForumPK var1, String var2);

    public boolean isSubscriberByInheritance(ForumPK var1, String var2);

    public boolean isSubscriber(String var1, String var2);

    public void createIndex(ForumPK var1);

    public void createIndex(MessagePK var1);

    public int getSilverObjectId(ForumPK var1);

    public String createCategory(NodeDetail var1);

    public void deleteCategory(String var1, String var2);

    public void updateCategory(NodeDetail var1);

    public NodeDetail getCategory(NodePK var1);

    public Collection<NodeDetail> getAllCategories(String var1);

    public String getForumTags(ForumPK var1);

    public String getMessageTags(MessagePK var1);

    public Collection<Message> getLastThreads(ForumPK var1, int var2);

    public Collection<Message> getNotAnsweredLastThreads(ForumPK var1, int var2);
}

