/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.classifieds.notification;

import java.util.Collection;
import java.util.Collections;
import org.silverpeas.components.classifieds.model.ClassifiedDetail;
import org.silverpeas.components.classifieds.notification.AbstractClassifiedUserNotification;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.template.SilverpeasTemplate;

public class ClassifiedValidationUserNotification
extends AbstractClassifiedUserNotification {
    private final String userIdWhoRefuse;
    private final String refusalMotive;
    private final String userToBeNotified;

    public ClassifiedValidationUserNotification(ClassifiedDetail resource, String userIdWhoRefuse, String refusalMotive, String userToBeNotified) {
        super(resource);
        this.userIdWhoRefuse = userIdWhoRefuse;
        this.refusalMotive = refusalMotive;
        this.userToBeNotified = userToBeNotified;
    }

    protected Collection<String> getUserIdsToNotify() {
        return Collections.singletonList(this.userToBeNotified);
    }

    protected String getBundleSubjectKey() {
        if (!((ClassifiedDetail)this.getResource()).isValid()) {
            return "classifieds.classifiedRefused";
        }
        return "classifieds.classifiedValidated";
    }

    protected String getTemplateFileName() {
        if (!((ClassifiedDetail)this.getResource()).isValid()) {
            return "refused";
        }
        return "validated";
    }

    protected void perform(ClassifiedDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().setOriginalExtraMessage(this.refusalMotive);
    }

    @Override
    protected void performTemplateData(String language, ClassifiedDetail resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("refusalMotive", (Object)this.refusalMotive);
    }

    protected NotifAction getAction() {
        if (!((ClassifiedDetail)this.getResource()).isValid()) {
            return NotifAction.REFUSE;
        }
        return NotifAction.VALIDATE;
    }

    @Override
    protected String getSender() {
        return this.userIdWhoRefuse;
    }
}

