/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.silverpeas.components.formsonline.model.AbstractFormsOnlineIT;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.FormsOnlineDAOJdbcIT;
import org.silverpeas.components.formsonline.model.FormsOnlineException;
import org.silverpeas.components.formsonline.model.FormsOnlineService;
import org.silverpeas.components.formsonline.model.RequestsByStatus;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.test.BasicWarBuilder;

@RunWith(value=Arquillian.class)
public class FormsOnlineServiceTestIT
extends AbstractFormsOnlineIT {
    @Inject
    private FormsOnlineService service;

    @Deployment
    public static Archive<?> createTestArchive() {
        return BasicWarBuilder.onWarForTestClass(FormsOnlineDAOJdbcIT.class).testFocusedOn(warBuilder -> {
            warBuilder.addMavenDependenciesWithPersistence(new String[]{"org.silverpeas.core:silverpeas-core"});
            warBuilder.addMavenDependencies(new String[]{"org.silverpeas.core.services:silverpeas-core-tagcloud"});
            warBuilder.addPackages(true, new String[]{"org.silverpeas.components.formsonline"});
        }).build();
    }

    @Test
    public void getAllUserRequests() throws FormsOnlineException {
        this.createDynamicContextOfData(2, 90, new String[]{"1", "1", "1", "1", "1", "1", "1", "1", "1", "2", "2", "2", "2", "2", "2", "2", "2", "2"}, new Integer[]{0, 1, 2, 2, 4, 4, 3, 3, 5}, new Object[]{null, null, null, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, false, "2020-01-01 06:54:23.26", "OK"}}, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.REFUSED, false, "2020-01-01 06:54:23.26", "Ha non"}}, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, false, "2020-01-01 06:54:23.26", "OK"}, {"31", FormInstanceValidationType.FINAL, ContributionStatus.REFUSED, false, "2020-03-03 15:08:01.07", "En fait non !"}}, new Object[][]{{"30", FormInstanceValidationType.INTERMEDIATE, ContributionStatus.VALIDATED, false, "2020-02-02 11:55:34.38", "OK"}, {"31", FormInstanceValidationType.FINAL, ContributionStatus.VALIDATED, false, "2020-03-03 15:08:01.07", "OK !"}}, new Object[][]{{"29", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, true, "2020-01-01 06:54:23.26", "OK"}, {"30", FormInstanceValidationType.INTERMEDIATE, ContributionStatus.VALIDATED, true, "2020-02-02 11:55:34.38", "OK aussi"}, {"31", FormInstanceValidationType.FINAL, ContributionStatus.VALIDATED, false, "2020-03-03 15:08:01.07", "Bon ben d'accord alors"}}, new Object[][]{{"30", FormInstanceValidationType.HIERARCHICAL, ContributionStatus.VALIDATED, false, "2020-01-01 06:54:23.26", "OK ARCH"}, {"31", FormInstanceValidationType.FINAL, ContributionStatus.VALIDATED, false, "2020-03-03 15:08:01.07", "OK ! ARCH"}}});
        RequestsByStatus requestsByStatus = this.service.getAllUserRequests("formsOnline26", DEFAULT_CREATOR_IDS[0], null);
        MatcherAssert.assertThat((Object)requestsByStatus, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)requestsByStatus.getAll(), (Matcher)Matchers.hasSize((int)90));
        MatcherAssert.assertThat((Object)requestsByStatus.getDraft(), (Matcher)Matchers.hasSize((int)10));
        MatcherAssert.assertThat((Object)requestsByStatus.getToValidate(), (Matcher)Matchers.hasSize((int)30));
        MatcherAssert.assertThat((Object)requestsByStatus.getValidated(), (Matcher)Matchers.hasSize((int)20));
        MatcherAssert.assertThat((Object)requestsByStatus.getDenied(), (Matcher)Matchers.hasSize((int)20));
        MatcherAssert.assertThat((Object)requestsByStatus.getArchived(), (Matcher)Matchers.hasSize((int)10));
        requestsByStatus = this.service.getAllUserRequests("formsOnline26", DEFAULT_CREATOR_IDS[0], new PaginationPage(2, 9));
        MatcherAssert.assertThat((Object)requestsByStatus, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)requestsByStatus.getAll(), (Matcher)Matchers.hasSize((int)9));
        requestsByStatus = this.service.getAllUserRequests("unknownInstanceId", DEFAULT_CREATOR_IDS[0], null);
        MatcherAssert.assertThat((Object)requestsByStatus, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)requestsByStatus.isEmpty(), (Matcher)Matchers.is((Object)true));
    }
}

