/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.datawarning.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.components.datawarning.DataWarningException;
import org.silverpeas.components.datawarning.model.DataWarning;
import org.silverpeas.components.datawarning.model.DataWarningGroup;
import org.silverpeas.components.datawarning.model.DataWarningQuery;
import org.silverpeas.components.datawarning.model.DataWarningScheduler;
import org.silverpeas.components.datawarning.model.DataWarningUser;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanIntf;
import org.silverpeas.core.util.logging.SilverLogger;

public class DataWarningDataManager {
    private static final String DATA_WARNING_EX_DATA_ACCESS_FAILED = "DataWarning.EX_DATA_ACCESS_FAILED";
    private static final String INSTANCE_ID_MSG = "instanceId = '";
    private SilverpeasBeanDAO<DataWarning> dataWarningDAO;
    private SilverpeasBeanDAO<DataWarningGroup> dataWarningGroupDAO;
    private SilverpeasBeanDAO<DataWarningUser> dataWarningUserDAO;
    private SilverpeasBeanDAO<DataWarningQuery> dataWarningQueryDAO;
    private SilverpeasBeanDAO<DataWarningScheduler> dataWarningSchedulerDAO;

    public DataWarningDataManager() throws DataWarningException {
        try {
            this.dataWarningDAO = SilverpeasBeanDAOFactory.getDAO((String)DataWarning.class.getName());
            this.dataWarningGroupDAO = SilverpeasBeanDAOFactory.getDAO((String)DataWarningGroup.class.getName());
            this.dataWarningUserDAO = SilverpeasBeanDAOFactory.getDAO((String)DataWarningUser.class.getName());
            this.dataWarningQueryDAO = SilverpeasBeanDAOFactory.getDAO((String)DataWarningQuery.class.getName());
            this.dataWarningSchedulerDAO = SilverpeasBeanDAOFactory.getDAO((String)DataWarningScheduler.class.getName());
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.DataWarningDataManager()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void createDataWarning(DataWarning dw) throws DataWarningException {
        try {
            this.dataWarningDAO.add((SilverpeasBeanIntf)dw);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.createDataWarning()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void deleteDataWarning(String instanceId) throws DataWarningException {
        try {
            String whereClause = "instanceID = '" + instanceId + "'";
            this.dataWarningDAO.removeWhere((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.deleteDataWarning()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void updateDataWarning(DataWarning dw) throws DataWarningException {
        try {
            DataWarning dataWarning = this.getDataWarning(dw.getInstanceId());
            if (dataWarning == null) {
                this.createDataWarning(dw);
            } else {
                this.dataWarningDAO.update((SilverpeasBeanIntf)dw);
            }
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.updateDataWarning()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public DataWarning getDataWarning(String instanceId) throws DataWarningException {
        DataWarning retour = null;
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "'";
            Collection datas = this.dataWarningDAO.findByWhereClause((WAPrimaryKey)new IdPK(), whereClause);
            if (datas != null && !datas.isEmpty()) {
                Iterator it = datas.iterator();
                retour = (DataWarning)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.getDataWarning()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
        return retour;
    }

    public void createDataWarningQuery(DataWarningQuery dwq) throws DataWarningException {
        try {
            this.dataWarningQueryDAO.add((SilverpeasBeanIntf)dwq);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.createDataWarningQuery()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void deleteDataWarningQuery(String instanceId) throws DataWarningException {
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "'";
            this.dataWarningQueryDAO.removeWhere((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.deleteDataWarningQuery()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void deleteDataWarningQuery(String instanceId, int queryCondition) throws DataWarningException {
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "' and queryCondition = " + queryCondition;
            this.dataWarningQueryDAO.removeWhere((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.deleteDataWarningQuery()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void updateDataWarningQuery(DataWarningQuery dwq) throws DataWarningException {
        try {
            DataWarningQuery dataQuery = this.getDataWarningQuery(dwq.getInstanceId(), dwq.getQueryCondition());
            if (dataQuery == null) {
                this.createDataWarningQuery(dwq);
            } else {
                this.dataWarningQueryDAO.update((SilverpeasBeanIntf)dwq);
            }
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.updateDataWarningQuery()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public DataWarningQuery getDataWarningQuery(String instanceId, int queryCondition) throws DataWarningException {
        DataWarningQuery retour = null;
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "' and queryCondition = " + queryCondition;
            Collection datas = this.dataWarningQueryDAO.findByWhereClause((WAPrimaryKey)new IdPK(), whereClause);
            if (datas != null && !datas.isEmpty()) {
                Iterator it = datas.iterator();
                retour = (DataWarningQuery)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.getDataWarningQuery()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
        return retour;
    }

    public Collection<DataWarningQuery> getDataWarningQueries(String instanceId) throws DataWarningException {
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "'";
            return this.dataWarningQueryDAO.findByWhereClause((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.getDataWarningQueries()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void createDataWarningScheduler(DataWarningScheduler dws) throws DataWarningException {
        try {
            this.dataWarningSchedulerDAO.add((SilverpeasBeanIntf)dws);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.createDataWarningScheduler()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void deleteDataWarningScheduler(String instanceId) throws DataWarningException {
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "'";
            this.dataWarningSchedulerDAO.removeWhere((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.deleteDataWarningScheduler()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void updateDataWarningScheduler(DataWarningScheduler dws) throws DataWarningException {
        try {
            DataWarningScheduler scheduler = this.getDataWarningScheduler(dws.getInstanceId());
            if (scheduler == null) {
                this.createDataWarningScheduler(dws);
            } else {
                this.dataWarningSchedulerDAO.update((SilverpeasBeanIntf)dws);
            }
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.updateDataWarningScheduler()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public DataWarningScheduler getDataWarningScheduler(String instanceId) throws DataWarningException {
        DataWarningScheduler retour = null;
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "'";
            Collection datas = this.dataWarningSchedulerDAO.findByWhereClause((WAPrimaryKey)new IdPK(), whereClause);
            if (datas != null && !datas.isEmpty()) {
                Iterator it = datas.iterator();
                retour = (DataWarningScheduler)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.getDataWarningScheduler()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
        return retour;
    }

    public List<String> getDataWarningSchedulerInstances() throws DataWarningException {
        ArrayList<String> retour = new ArrayList<String>();
        Connection con = null;
        Statement stmt = null;
        ResultSet rsSchedulers = null;
        try {
            con = DBUtil.openConnection();
            String sqlForSchedulers = "SELECT DISTINCT instanceId FROM SC_DataWarning_Scheduler WHERE SCHEDULERSTATE=1";
            stmt = con.createStatement();
            rsSchedulers = stmt.executeQuery(sqlForSchedulers);
            while (rsSchedulers.next()) {
                retour.add(rsSchedulers.getString(1));
            }
            this.closeAllConnection(con, stmt, rsSchedulers);
        }
        catch (Exception e) {
            try {
                throw new DataWarningException("DataWarningDataManager.getDataWarningSchedulerInstances", 3, e.getMessage(), "getDataWarningScheduler", e);
            }
            catch (Throwable throwable) {
                this.closeAllConnection(con, stmt, rsSchedulers);
                throw throwable;
            }
        }
        return retour;
    }

    public void createDataWarningGroup(DataWarningGroup dwg) throws DataWarningException {
        try {
            this.dataWarningGroupDAO.add((SilverpeasBeanIntf)dwg);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.createDataWarningGroup()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void deleteDataWarningGroup(String instanceId, int groupId) throws DataWarningException {
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "' and groupId = " + Integer.toString(groupId);
            this.dataWarningGroupDAO.removeWhere((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.deleteDataWarningGroup()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void deleteDataWarningGroups(String instanceId) throws DataWarningException {
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "'";
            this.dataWarningGroupDAO.removeWhere((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.deleteDataWarningGroups()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void updateDataWarningGroup(DataWarningGroup dwg) throws DataWarningException {
        try {
            this.dataWarningGroupDAO.update((SilverpeasBeanIntf)dwg);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.updateDataWarningGroup()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public Collection<DataWarningGroup> getDataWarningGroups(String instanceId) throws DataWarningException {
        Collection retour;
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "'";
            retour = this.dataWarningGroupDAO.findByWhereClause((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.getDataWarningGroups()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
        return retour;
    }

    public DataWarningGroup getDataWarningGroup(String instanceId, int groupId) throws DataWarningException {
        DataWarningGroup retour = null;
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "' and groupId = " + Integer.toString(groupId);
            Collection datas = this.dataWarningGroupDAO.findByWhereClause((WAPrimaryKey)new IdPK(), whereClause);
            if (datas != null && !datas.isEmpty()) {
                Iterator it = datas.iterator();
                retour = (DataWarningGroup)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.getDataWarningGroup()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
        return retour;
    }

    public void createDataWarningUser(DataWarningUser dwu) throws DataWarningException {
        try {
            this.dataWarningUserDAO.add((SilverpeasBeanIntf)dwu);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.createDataWarningUser()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void deleteDataWarningUser(String instanceId, int userId) throws DataWarningException {
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "' and userId = " + userId;
            this.dataWarningUserDAO.removeWhere((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningSessionController.deleteDataWarningUser()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void deleteDataWarningUsers(String instanceId) throws DataWarningException {
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "'";
            this.dataWarningUserDAO.removeWhere((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningSessionController.deleteDataWarningUsers()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public void updateDataWarningUser(DataWarningUser dwu) throws DataWarningException {
        try {
            this.dataWarningUserDAO.update((SilverpeasBeanIntf)dwu);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningSessionController.updateDataWarningUser()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
    }

    public Collection<DataWarningUser> getDataWarningUsers(String instanceId) throws DataWarningException {
        Collection retour;
        try {
            String whereClause = "instanceId ='" + instanceId + "'";
            retour = this.dataWarningUserDAO.findByWhereClause((WAPrimaryKey)new IdPK(), whereClause);
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningSessionController.getDataWarningUsers()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
        return retour;
    }

    public DataWarningUser getDataWarningUser(String instanceId, String userId) throws DataWarningException {
        DataWarningUser retour = null;
        try {
            String whereClause = INSTANCE_ID_MSG + instanceId + "' and userId = " + userId;
            Collection datas = this.dataWarningUserDAO.findByWhereClause((WAPrimaryKey)new IdPK(), whereClause);
            if (datas != null && !datas.isEmpty()) {
                Iterator it = datas.iterator();
                retour = (DataWarningUser)((Object)it.next());
            }
        }
        catch (Exception e) {
            throw new DataWarningException("DataWarningDataManager.getDataWarningUser()", 4, DATA_WARNING_EX_DATA_ACCESS_FAILED, e);
        }
        return retour;
    }

    public Connection openConnection() throws DataWarningException {
        Connection con;
        try {
            con = DBUtil.openConnection();
        }
        catch (Exception e) {
            throw new DataWarningException(DataWarningDataManager.class.getName(), 3, e.getMessage(), "openConnection", e);
        }
        return con;
    }

    public void closeConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnection(Connection con, Statement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        finally {
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnection(Connection con, Statement st, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
        finally {
            this.closeAllConnection(con, st);
        }
    }
}

