/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jackrabbit.core.query.lucene.IndexInfos;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexHistory {
    private static final Logger log = LoggerFactory.getLogger(IndexHistory.class);
    private static final String INDEXES = "indexes";
    private final Directory indexDir;
    private final long maxAge;
    private final Map<Long, IndexInfos> indexInfosMap = new TreeMap(Collections.reverseOrder());

    IndexHistory(Directory dir, long maxAge) throws IOException {
        this.indexDir = dir;
        this.maxAge = maxAge;
        String[] names = dir.listAll();
        if (names != null) {
            for (String name : names) {
                long gen;
                if (!name.startsWith(INDEXES)) continue;
                if (name.length() == INDEXES.length()) {
                    gen = 0L;
                } else {
                    if (name.charAt(INDEXES.length()) != '_') continue;
                    gen = Long.parseLong(name.substring(INDEXES.length() + 1), 36);
                }
                try {
                    IndexInfos infos = new IndexInfos(dir, INDEXES, gen);
                    this.indexInfosMap.put(gen, infos);
                }
                catch (IOException e) {
                    log.warn("ignoring invalid index infos file: " + name);
                }
            }
        }
    }

    long getLastUseOf(String indexName) {
        Long previous = null;
        for (Map.Entry<Long, IndexInfos> entry : this.indexInfosMap.entrySet()) {
            IndexInfos infos = entry.getValue();
            if (infos.contains(indexName)) {
                if (previous == null) {
                    return Long.MAX_VALUE;
                }
                return previous;
            }
            previous = infos.getLastModified();
        }
        return Long.MIN_VALUE;
    }

    void pruneOutdated() {
        IndexInfos infos;
        long threshold = System.currentTimeMillis() - this.maxAge;
        log.debug("Pruning index infos older than: " + threshold + "(" + this.indexDir + ")");
        Iterator<IndexInfos> it = this.indexInfosMap.values().iterator();
        if (it.hasNext()) {
            infos = it.next();
            log.debug("Skipping first index infos. generation=" + infos.getGeneration());
        }
        while (it.hasNext()) {
            infos = it.next();
            if (infos.getLastModified() >= threshold) continue;
            try {
                String logName = this.getRedoLogName(infos.getGeneration());
                if (this.indexDir.fileExists(logName)) {
                    long lastModified = this.indexDir.fileModified(logName);
                    if (lastModified > threshold) {
                        log.debug("Keeping redo log with generation={}, timestamp={}", (Object)infos.getGeneration(), (Object)lastModified);
                        continue;
                    }
                    try {
                        this.indexDir.deleteFile(logName);
                        log.debug("Deleted redo log with generation={}, timestamp={}", (Object)infos.getGeneration(), (Object)lastModified);
                    }
                    catch (IOException e) {
                        log.warn("Unable to delete: " + this.indexDir + "/" + logName);
                        continue;
                    }
                }
                try {
                    this.indexDir.deleteFile(infos.getFileName());
                    log.debug("Deleted index infos with generation={}", (Object)infos.getGeneration());
                    it.remove();
                }
                catch (IOException e) {
                    log.warn("Unable to delete: " + this.indexDir + "/" + infos.getFileName());
                }
            }
            catch (IOException e) {
                log.warn("Failed to check if {} is outdated: {}", (Object)infos.getFileName(), (Object)e);
            }
        }
    }

    void addIndexInfos(IndexInfos infos) {
        this.indexInfosMap.put(infos.getGeneration(), infos.clone());
    }

    String getRedoLogName(long generation) {
        if (generation == 0L) {
            return "redo.log";
        }
        return "redo_" + Long.toString(generation, 36) + ".log";
    }
}

