/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.rs.aspect;

import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.web.rs.ProtectedWebResource;
import org.silverpeas.core.web.rs.aspect.ComponentInstMustExistIfSpecified;

@Interceptor
@ComponentInstMustExistIfSpecified
@Priority(value=2000)
public class ComponentExistenceAspect {
    @AroundInvoke
    public Object processAuthorization(InvocationContext context) throws Exception {
        Object target = context.getTarget();
        if (target instanceof ProtectedWebResource) {
            ProtectedWebResource resource = (ProtectedWebResource)target;
            String instanceId = null;
            try {
                instanceId = resource.getComponentId();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtil.isDefined((String)instanceId)) {
                OrganizationController controller = OrganizationControllerProvider.getOrganisationController();
                if (!(PersonalComponentInstance.from((String)instanceId).isPresent() || controller.isComponentExist(instanceId) || controller.isToolAvailable(instanceId) || controller.isAdminTool(instanceId))) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
            }
        }
        return context.proceed();
    }
}

