/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.service;

import java.lang.annotation.Annotation;
import java.util.List;
import org.silverpeas.components.gallery.model.GalleryRuntimeException;
import org.silverpeas.components.gallery.model.Order;
import org.silverpeas.components.gallery.service.GalleryService;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.logging.SilverLogger;

public class ScheduledDeleteOrder
implements SchedulerEventListener {
    public static final String GALLERYENGINE_JOB_NAME = "GalleryEngineJobOrder";

    public void initialize() {
        try {
            SettingBundle resources = ResourceLocator.getSettingBundle((String)"org.silverpeas.gallery.settings.gallerySettings");
            String cron = resources.getString("cronScheduledDeleteOrder");
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(GALLERYENGINE_JOB_NAME);
            JobTrigger trigger = JobTrigger.triggerAt((String)cron);
            scheduler.scheduleJob(GALLERYENGINE_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    public void doScheduledDeleteOrder() {
        try {
            SettingBundle resources = ResourceLocator.getSettingBundle((String)"org.silverpeas.gallery.settings.gallerySettings");
            int nbDays = resources.getInteger("nbDaysForDeleteOrder");
            List<Order> orders = this.getGalleryService().getAllOrderToDelete(nbDays);
            this.getGalleryService().deleteOrders(orders);
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    private GalleryService getGalleryService() {
        return (GalleryService)ServiceProvider.getService(GalleryService.class, (Annotation[])new Annotation[0]);
    }

    public void triggerFired(SchedulerEvent anEvent) {
        this.doScheduledDeleteOrder();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
        SilverLogger.getLogger((Object)this).error("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull", new Object[0]);
    }
}

