/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.infoletter.model;

import java.util.Optional;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.infoletter.model.InfoLetter;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.content.ddwe.model.DragAndDropWebEditorStore;
import org.silverpeas.core.contribution.content.renderer.ContributionContentRenderer;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.model.ContributionContent;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.ddwe.DragAndDropEditorContent;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBean;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.URLUtil;

public class InfoLetterPublication
extends SilverpeasBean
implements Comparable<InfoLetter> {
    private static final long serialVersionUID = 2579802983989822400L;
    public static final int PUBLICATION_EN_REDACTION = 1;
    public static final int PUBLICATION_VALIDEE = 2;
    private String instanceId;
    private String title;
    private String description;
    private String parutionDate;
    private int publicationState;
    private int letterId;
    private WysiwygContent content;

    public InfoLetterPublication() {
        this.title = "";
        this.description = "";
        this.parutionDate = "";
        this.publicationState = 1;
        this.letterId = 0;
    }

    public InfoLetterPublication(WAPrimaryKey pk, String instanceId, String title, String description, String parutionDate, int publicationState, int letterId) {
        this.setPK(pk);
        this.instanceId = instanceId;
        this.title = title;
        this.description = description;
        this.parutionDate = parutionDate;
        this.publicationState = publicationState;
        this.letterId = letterId;
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((String)this.getInstanceId(), (String)this.getPK().getId(), (String)"publication");
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParutionDate() {
        return this.parutionDate;
    }

    public void setParutionDate(String parutionDate) {
        this.parutionDate = parutionDate;
    }

    public int getPublicationState() {
        return this.publicationState;
    }

    public void setPublicationState(int publicationState) {
        this.publicationState = publicationState;
    }

    public int getLetterId() {
        return this.letterId;
    }

    public void setLetterId(int letterId) {
        this.letterId = letterId;
    }

    public void setLetterId(String letterId) {
        this.letterId = Integer.parseInt(letterId);
    }

    public String _getPermalink() {
        return URLUtil.getSimpleURL((int)11, (String)this.getPK().getId());
    }

    public int _getConnectionType() {
        return 1;
    }

    @Override
    public int compareTo(InfoLetter obj) {
        if (obj == null) {
            return 0;
        }
        return String.valueOf(this.getPK().getId()).compareTo(String.valueOf(obj.getPK().getId()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InfoLetter)) {
            return false;
        }
        InfoLetter that = (InfoLetter)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getPK().getId()).append((Object)this.getPK().getInstanceId()).toHashCode();
    }

    public String _getTableName() {
        return "SC_IL_Publication";
    }

    public boolean _isValid() {
        return this.publicationState == 2;
    }

    public String initFrom(InfoLetter infoLetter) {
        String templateContent = Optional.of(new DragAndDropWebEditorStore(infoLetter.getTemplateIdentifier())).map(DragAndDropWebEditorStore::getFile).filter(SilverpeasFile::exists).map(DragAndDropWebEditorStore.File::getContainer).flatMap(DragAndDropWebEditorStore.Container::getContent).map(DragAndDropWebEditorStore.Content::getValue).orElseGet(() -> infoLetter.getTemplateWysiwygContent().map(ContributionContent::getRenderer).map(ContributionContentRenderer::renderEdition).filter(StringUtil::isDefined).orElse(""));
        ResourceReference templateRef = infoLetter.getTemplateIdentifier().toReference();
        ResourceReference parutionRef = this.getIdentifier().toReference();
        String newContent = (String)WysiwygController.copyDocumentsBetweenTwoResourcesWithSourceContent((ResourceReference)templateRef, (ResourceReference)parutionRef, (String)templateContent).getFirst();
        DragAndDropWebEditorStore store = new DragAndDropWebEditorStore(this.getIdentifier());
        store.getFile().getContainer().getOrCreateTmpContent().setValue(newContent);
        store.getFile().getContainer().getOrCreateContent().setValue(newContent);
        store.save();
        this.saveContent(new DragAndDropEditorContent(newContent).getInlinedHtml());
        return newContent;
    }

    public Optional<WysiwygContent> getWysiwygContent() {
        if (this.content == null) {
            this.content = WysiwygController.get((String)this.getInstanceId(), (String)this.getPK().getId(), (String)I18NHelper.DEFAULT_LANGUAGE);
        }
        return Optional.ofNullable(this.content);
    }

    public void saveContent(String manualContent) {
        this.content = null;
        ContributionIdentifier identifier = this.getIdentifier();
        String wysiwygContent = manualContent;
        if (StringUtil.isNotDefined((String)manualContent)) {
            DragAndDropWebEditorStore store = new DragAndDropWebEditorStore(identifier);
            wysiwygContent = store.getFile().getContainer().getTmpContent().map(DragAndDropWebEditorStore.Content::getValue).map(c -> {
                store.getFile().getContainer().getOrCreateContent().setValue(c);
                store.save();
                DragAndDropEditorContent editorContent = new DragAndDropEditorContent(c);
                return editorContent.getInlinedHtml();
            }).orElse(manualContent);
        }
        WysiwygController.updateFileAndAttachment((String)wysiwygContent, (String)identifier.getComponentInstanceId(), (String)identifier.getLocalId(), (String)User.getCurrentUser().getId(), (String)I18NHelper.DEFAULT_LANGUAGE);
    }

    public void deleteContent() {
        ContributionIdentifier identifier = this.getIdentifier();
        WysiwygController.deleteWysiwygAttachments((String)identifier.getComponentInstanceId(), (String)identifier.getLocalId());
        new DragAndDropWebEditorStore(identifier).delete();
    }
}

