/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.RequestValidationCriteria;
import org.silverpeas.components.formsonline.model.RequestsByStatus;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.Pair;

class RequestsByStatusTest {
    private static final BiConsumer<Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>, RequestValidationCriteria> TO_VALIDATE_CONFIGURER = RequestsByStatus.toValidateCriteriaConfigurer;

    RequestsByStatusTest() {
    }

    @Test
    void configureValidationCriteriaWhenNoFormValidation() {
        Set<FormInstanceValidationType> noValidation = this.possibleFormValidationTypes(new FormInstanceValidationType[0]);
        RequestValidationCriteria criteria = this.configureToValidateWith(noValidation, this.possibleValidatorValidationTypes(new FormInstanceValidationType[0]));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(noValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(noValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(noValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(noValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(noValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(noValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(noValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
    }

    @Test
    void configureValidationCriteriaWhenFinalFormValidation() {
        Set<FormInstanceValidationType> finalValidation = this.possibleFormValidationTypes(FormInstanceValidationType.FINAL);
        RequestValidationCriteria criteria = this.configureToValidateWith(finalValidation, this.possibleValidatorValidationTypes(new FormInstanceValidationType[0]));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(finalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(finalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(finalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(finalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(finalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(finalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(finalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
    }

    @Test
    void configureValidationCriteriaWhenIntermediateFormValidation() {
        Set<FormInstanceValidationType> intermediateValidation = this.possibleFormValidationTypes(FormInstanceValidationType.INTERMEDIATE);
        RequestValidationCriteria criteria = this.configureToValidateWith(intermediateValidation, this.possibleValidatorValidationTypes(new FormInstanceValidationType[0]));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
    }

    @Test
    void configureValidationCriteriaWhenHierarchicalFormValidation() {
        Set<FormInstanceValidationType> hierarchicalValidation = this.possibleFormValidationTypes(FormInstanceValidationType.HIERARCHICAL);
        RequestValidationCriteria criteria = this.configureToValidateWith(hierarchicalValidation, this.possibleValidatorValidationTypes(new FormInstanceValidationType[0]));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
    }

    @Test
    void configureValidationCriteriaWhenIntermediateAndFinalFormValidation() {
        Set<FormInstanceValidationType> intermediateAndFinalValidation = this.possibleFormValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL);
        RequestValidationCriteria criteria = this.configureToValidateWith(intermediateAndFinalValidation, this.possibleValidatorValidationTypes(new FormInstanceValidationType[0]));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE}));
        criteria = this.configureToValidateWith(intermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE}));
        criteria = this.configureToValidateWith(intermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE}));
        criteria = this.configureToValidateWith(intermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(intermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE}));
    }

    @Test
    void configureValidationCriteriaWhenHierarchicalAndFinalFormValidation() {
        Set<FormInstanceValidationType> hierarchicalAndFinalValidation = this.possibleFormValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL);
        RequestValidationCriteria criteria = this.configureToValidateWith(hierarchicalAndFinalValidation, this.possibleValidatorValidationTypes(new FormInstanceValidationType[0]));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
        criteria = this.configureToValidateWith(hierarchicalAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
        criteria = this.configureToValidateWith(hierarchicalAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
        criteria = this.configureToValidateWith(hierarchicalAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
    }

    @Test
    void configureValidationCriteriaWhenHierarchicalAndIntermediateFormValidation() {
        Set<FormInstanceValidationType> hierarchicalAndIntermediateValidation = this.possibleFormValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE);
        RequestValidationCriteria criteria = this.configureToValidateWith(hierarchicalAndIntermediateValidation, this.possibleValidatorValidationTypes(new FormInstanceValidationType[0]));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
    }

    @Test
    void configureValidationCriteriaWhenHierarchicalAndIntermediateAndFinalFormValidation() {
        Set<FormInstanceValidationType> hierarchicalAndIntermediateAndFinalValidation = this.possibleFormValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL);
        RequestValidationCriteria criteria = this.configureToValidateWith(hierarchicalAndIntermediateAndFinalValidation, this.possibleValidatorValidationTypes(new FormInstanceValidationType[0]));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE}));
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.empty());
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.INTERMEDIATE}));
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE}));
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL}));
        criteria = this.configureToValidateWith(hierarchicalAndIntermediateAndFinalValidation, this.possibleValidatorValidationTypes(FormInstanceValidationType.INTERMEDIATE, FormInstanceValidationType.FINAL));
        MatcherAssert.assertThat((Object)criteria.isOrValidatorIsHierarchicalOne(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.isOrNoValidator(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)criteria.getOrLastValidationType(), (Matcher)Matchers.contains((Object[])new FormInstanceValidationType[]{FormInstanceValidationType.HIERARCHICAL, FormInstanceValidationType.INTERMEDIATE}));
    }

    private RequestValidationCriteria configureToValidateWith(Set<FormInstanceValidationType> possibleFormValidationTypes, Set<FormInstanceValidationType> possibleValidatorValidationTypes) {
        RequestValidationCriteria validationCriteria = RequestValidationCriteria.withValidatorId((String)"1", null);
        TO_VALIDATE_CONFIGURER.accept((Pair<Set<FormInstanceValidationType>, Set<FormInstanceValidationType>>)Pair.of(new TreeSet<FormInstanceValidationType>(possibleFormValidationTypes), new TreeSet<FormInstanceValidationType>(possibleValidatorValidationTypes)), validationCriteria);
        MatcherAssert.assertThat((Object)validationCriteria.getValidatorId(), (Matcher)Matchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)validationCriteria.isAvoidValidatedByValidator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)validationCriteria.isStillNeedValidation(), (Matcher)Matchers.is((Object)false));
        return validationCriteria;
    }

    private Set<FormInstanceValidationType> possibleFormValidationTypes(FormInstanceValidationType ... types) {
        return CollectionUtil.asSet((Object[])types);
    }

    private Set<FormInstanceValidationType> possibleValidatorValidationTypes(FormInstanceValidationType ... types) {
        return CollectionUtil.asSet((Object[])types);
    }
}

