/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.formsonline.model;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Transient;
import org.silverpeas.components.formsonline.model.FormDetail;
import org.silverpeas.components.formsonline.model.FormInstanceValidation;
import org.silverpeas.components.formsonline.model.FormInstanceValidationType;
import org.silverpeas.components.formsonline.model.FormInstanceValidations;
import org.silverpeas.components.formsonline.model.FormPK;
import org.silverpeas.components.formsonline.model.RequestPK;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.ContributionStatus;
import org.silverpeas.core.contribution.content.form.Form;
import org.silverpeas.core.contribution.model.ContributionValidation;
import org.silverpeas.core.contribution.model.SilverpeasContent;

public class FormInstance
implements SilverpeasContent {
    private static final long serialVersionUID = -3341454138112938275L;
    public static final int STATE_DRAFT = 0;
    public static final int STATE_UNREAD = 1;
    public static final int STATE_READ = 2;
    public static final int STATE_VALIDATED = 3;
    public static final int STATE_REFUSED = 4;
    public static final int STATE_ARCHIVED = 5;
    public static final int STATE_CANCELED = 6;
    private final FormInstanceValidations validations = new FormInstanceValidations();
    @Transient
    protected transient FormDetail form;
    private String id;
    private int formId = -1;
    private int state = -1;
    private String creatorId = null;
    private Date creationDate = null;
    private String instanceId = null;
    @Transient
    private boolean validationEnabled = false;
    @Transient
    private transient Form formWithData;

    public String getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = Integer.toString(id);
    }

    public int getIdAsInt() {
        return Integer.parseInt(this.getId());
    }

    public String getComponentInstanceId() {
        return this.instanceId;
    }

    public int getFormId() {
        return this.formId;
    }

    public void setFormId(int formId) {
        this.formId = formId;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public Date getCreationDate() {
        return this.creationDate != null ? new Date(this.creationDate.getTime()) : null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate != null ? new Date(creationDate.getTime()) : null;
    }

    public Date getLastUpdateDate() {
        return this.getValidationDate() != null ? this.getValidationDate() : this.getCreationDate();
    }

    public String getTitle() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getContributionType() {
        return null;
    }

    public boolean canBeAccessedBy(User user) {
        String userId = user.getId();
        return this.getCreatorId().equals(userId) || this.form.isValidator(userId) || this.isHierarchicalValidator(userId);
    }

    public boolean canBeDeletedBy(User user) {
        return (this.isDraft() || this.getForm().isDeleteAfterRequestExchange()) && user.getId().equals(this.getCreatorId()) || (this.isCanceled() || this.isValidated() || this.isDenied() || this.isArchived()) && this.isOneOfLastValidators(user);
    }

    public String getHierarchicalValidator() {
        return this.form.getHvManager().getHierarchicalValidatorOf(this.getCreatorId());
    }

    public boolean isHierarchicalValidator(String userId) {
        return this.form.isHierarchicalValidation() && userId.equals(this.getHierarchicalValidator());
    }

    public FormInstanceValidations getValidations() {
        return this.validations;
    }

    public List<FormInstanceValidation> getPreviousValidations() {
        return this.getValidationsSchema().stream().filter(v -> !v.isPendingValidation()).collect(Collectors.toList());
    }

    public List<FormInstanceValidation> getValidationsSchema() {
        return Stream.of(FormInstanceValidationType.values()).map(v -> this.getValidations().getValidationOfType((FormInstanceValidationType)((Object)v)).orElseGet(() -> {
            FormInstanceValidation validation;
            Function<FormInstance, Supplier<List<User>>> validatorSupplier = this.form.getPossibleRequestValidations().get(v);
            if (validatorSupplier != null) {
                validation = new FormInstanceValidation(this);
                validation.setValidationType((FormInstanceValidationType)((Object)v));
                validation.setStatus(ContributionStatus.PENDING_VALIDATION);
                List<User> validators = validatorSupplier.apply(this).get();
                if (validators.size() == 1) {
                    validation.setValidator(validators.get(0));
                }
            } else {
                validation = null;
            }
            return validation;
        })).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public FormInstanceValidation getPendingValidation() {
        return this.getValidationsSchema().stream().filter(ContributionValidation::isPendingValidation).findFirst().orElse(null);
    }

    public String getValidatorId() {
        return this.validations.getFinalValidation().map(v -> v.getValidator().getId()).orElse("");
    }

    public Date getValidationDate() {
        return this.validations.getFinalValidation().map(ContributionValidation::getDate).orElse(null);
    }

    public String getComments() {
        return this.validations.getFinalValidation().map(ContributionValidation::getComment).orElse("");
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public FormDetail getForm() {
        return this.form;
    }

    public void setForm(FormDetail form) {
        this.form = form;
    }

    public boolean isRead() {
        return this.getState() == 2;
    }

    public boolean isUnread() {
        return this.getState() == 1;
    }

    public boolean isCanceled() {
        return this.getState() == 6;
    }

    public boolean isValidated() {
        return this.getState() == 3;
    }

    public boolean isDenied() {
        return this.getState() == 4;
    }

    public boolean isArchived() {
        return this.getState() == 5;
    }

    public boolean canBeValidated() {
        return !this.isCanceled() && !this.isValidated() && !this.isDenied() && !this.isArchived();
    }

    public boolean canBeArchivedBy(User user) {
        return (this.isCanceled() || this.isValidated() || this.isDenied()) && this.isOneOfLastValidators(user);
    }

    private boolean isOneOfLastValidators(User user) {
        boolean isOneOfLastValidator;
        if (this.form.isFinalValidation()) {
            isOneOfLastValidator = this.form.isFinalValidator(user.getId());
            if (!isOneOfLastValidator && this.getValidations().getIntermediateValidation().filter(ContributionValidation::isRefused).isPresent()) {
                isOneOfLastValidator = this.form.isIntermediateValidator(user.getId());
            }
            if (!isOneOfLastValidator && this.getValidations().getHierarchicalValidation().filter(ContributionValidation::isRefused).isPresent()) {
                isOneOfLastValidator = this.getHierarchicalValidator().equals(user.getId());
            }
        } else if (this.form.isIntermediateValidation()) {
            isOneOfLastValidator = this.form.isIntermediateValidator(user.getId());
            if (!isOneOfLastValidator && this.getValidations().getHierarchicalValidation().filter(ContributionValidation::isRefused).isPresent()) {
                isOneOfLastValidator = this.getHierarchicalValidator().equals(user.getId());
            }
        } else {
            isOneOfLastValidator = this.form.isHierarchicalValidation() ? this.getHierarchicalValidator().equals(user.getId()) : false;
        }
        return isOneOfLastValidator;
    }

    public boolean canBeCanceledBy(User user) {
        return this.canBeValidated() && user.getId().equals(this.getCreatorId());
    }

    public boolean isDraft() {
        return this.getState() == 0;
    }

    public User getCreator() {
        return User.getById((String)this.getCreatorId());
    }

    public User getLastUpdater() {
        return this.validations.getFinalValidation().map(ContributionValidation::getValidator).orElseGet(this::getCreator);
    }

    public User getValidator() {
        return User.getById((String)this.getValidatorId());
    }

    public FormPK getFormPK() {
        return new FormPK(Integer.toString(this.getFormId()), this.getComponentInstanceId());
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public Form getFormWithData() {
        return this.formWithData;
    }

    public void setFormWithData(Form formWithData) {
        this.formWithData = formWithData;
    }

    public RequestPK getPK() {
        return new RequestPK(this.getId(), this.getComponentInstanceId());
    }

    public boolean isVoidable() {
        return this.isUnread() || this.isRead();
    }

    public List<String> getValidationsImages() {
        FormInstanceValidations validationForImages = this.canBeValidated() ? this.getValidationsSchema() : this.getValidations();
        return Stream.concat(Stream.of(this.isUnread() ? "vu.png" : "vu-ok.png"), validationForImages.stream().map(this::getValidationImage)).collect(Collectors.toList());
    }

    private String getValidationImage(FormInstanceValidation validation) {
        String prefix = "vh";
        if (validation.getValidationType().isIntermediate()) {
            prefix = "vi";
        } else if (validation.getValidationType().isFinal()) {
            prefix = "vf";
        }
        String stateSuffix = "";
        if (validation.isValidated()) {
            stateSuffix = "-ok";
        } else if (validation.isRefused()) {
            stateSuffix = "-nok";
        }
        return prefix + stateSuffix + ".png";
    }
}

