/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.gallery.constant.GalleryResourceURIs;
import org.silverpeas.components.gallery.constant.MediaResolution;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.model.AlbumMedia;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.model.Sound;
import org.silverpeas.components.gallery.model.Streaming;
import org.silverpeas.components.gallery.model.Video;
import org.silverpeas.components.gallery.notification.AlbumMediaEventNotifier;
import org.silverpeas.components.gallery.service.MediaServiceProvider;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentInterface;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.process.io.file.FileBasePath;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.StringUtil;
import org.silverpeas.core.util.URLUtil;

public abstract class Media
implements SilverContentInterface,
Serializable,
WithPermanentLink {
    private static final long serialVersionUID = -3193781401588525351L;
    public static final FileBasePath BASE_PATH = FileBasePath.UPLOAD_PATH;
    private MediaPK mediaPK;
    private String title = "";
    private String description = "";
    private String author = "";
    private String keyWord = "";
    private Period visibilityPeriod = Period.UNDEFINED;
    private Date createDate;
    private String createdBy;
    private User creator;
    private Date lastUpdateDate;
    private String lastUpdatedBy;
    private User lastUpdater;
    private String silverpeasContentId;
    private String iconUrl;

    public Media() {
        this.mediaPK = new MediaPK(null);
    }

    protected Media(Media other) {
        if (other.mediaPK != null) {
            this.mediaPK = new MediaPK(other.mediaPK.getId(), other.mediaPK.getInstanceId());
        }
        this.title = other.title;
        this.description = other.description;
        this.author = other.author;
        this.keyWord = other.keyWord;
        this.visibilityPeriod = other.visibilityPeriod;
        this.createDate = other.createDate;
        this.createdBy = other.createdBy;
        this.creator = other.creator;
        this.lastUpdateDate = other.lastUpdateDate;
        this.lastUpdatedBy = other.lastUpdatedBy;
        this.lastUpdater = other.lastUpdater;
        this.silverpeasContentId = other.silverpeasContentId;
        this.iconUrl = other.iconUrl;
    }

    public MediaPK getMediaPK() {
        return this.mediaPK;
    }

    public void setMediaPK(MediaPK mediaPK) {
        this.mediaPK = mediaPK;
    }

    public void setId(String mediaId) {
        this.getMediaPK().setId(mediaId);
    }

    public String getId() {
        return this.getMediaPK() != null ? this.getMediaPK().getId() : null;
    }

    public void setComponentInstanceId(String instanceId) {
        this.getMediaPK().setComponentName(instanceId);
    }

    public String getInstanceId() {
        return this.getMediaPK() != null ? this.getMediaPK().getInstanceId() : null;
    }

    public String getContributionType() {
        return this.getType().name();
    }

    public abstract MediaType getType();

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = StringUtil.isDefined((String)title) ? title : "";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = StringUtil.isDefined((String)description) ? description : "";
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = StringUtil.isDefined((String)author) ? author : "";
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    public void setKeyWord(String keyWord) {
        this.keyWord = StringUtil.isDefined((String)keyWord) ? keyWord : "";
    }

    public Period getVisibilityPeriod() {
        return this.visibilityPeriod;
    }

    public void setVisibilityPeriod(Period visibilityPeriod) {
        this.visibilityPeriod = Period.check((Period)visibilityPeriod);
    }

    public boolean isVisible() {
        Date today = DateUtil.getDate();
        return this.isVisible(today);
    }

    protected boolean isVisible(Date today) {
        boolean result = true;
        if (today != null && this.getVisibilityPeriod().isDefined()) {
            result = this.getVisibilityPeriod().contains(today);
        }
        return result;
    }

    public Date getCreationDate() {
        return this.createDate;
    }

    public void setCreationDate(Date createDate) {
        this.createDate = createDate;
    }

    public User getCreator() {
        if (StringUtil.isDefined((String)this.getCreatorId())) {
            if (this.creator == null || !this.getCreatorId().equals(this.creator.getId())) {
                this.creator = User.getById((String)this.getCreatorId());
            }
        } else {
            this.creator = null;
        }
        return this.creator;
    }

    public void setCreator(User creator) {
        this.creator = creator;
        this.setCreatorId(creator != null ? creator.getId() : null);
    }

    public String getCreatorId() {
        return this.createdBy;
    }

    public void setCreatorId(String creatorId) {
        this.createdBy = creatorId;
    }

    public String getCreatorName() {
        return this.getCreator() != null ? this.getCreator().getDisplayedName() : "";
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate != null ? this.lastUpdateDate : this.getCreationDate();
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public User getLastUpdater() {
        if (StringUtil.isDefined((String)this.getLastUpdatedBy())) {
            if (this.lastUpdater == null || !this.getLastUpdatedBy().equals(this.lastUpdater.getId())) {
                this.lastUpdater = User.getById((String)this.getLastUpdatedBy());
            }
        } else {
            this.setLastUpdater(this.getCreator());
        }
        return this.lastUpdater;
    }

    public void setLastUpdater(User lastUpdater) {
        this.lastUpdater = lastUpdater;
        this.setLastUpdatedBy(lastUpdater != null ? lastUpdater.getId() : null);
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public String getLastUpdaterName() {
        return this.getLastUpdater() != null ? this.getLastUpdater().getDisplayedName() : "";
    }

    public boolean canBeAccessedBy(User user) {
        return super.canBeAccessedBy(user) && (this.isVisible(DateUtil.getDate()) || user.isAccessAdmin() || this.getHighestUserRole(user).isGreaterThanOrEquals(SilverpeasRole.PUBLISHER) || this.getHighestUserRole(user).isGreaterThanOrEquals(SilverpeasRole.WRITER) && user.getId().equals(this.getCreatorId()));
    }

    public String getWorkspaceSubFolderName() {
        return this.getType().getTechnicalFolder() + this.getId();
    }

    public String getPermalink() {
        return URLUtil.getPermalink((URLUtil.Permalink)URLUtil.Permalink.MEDIA, (String)this.getId());
    }

    public boolean isPreviewable() {
        return true;
    }

    public String getApplicationThumbnailUrl(MediaResolution mediaResolution) {
        if (mediaResolution == null) {
            mediaResolution = MediaResolution.PREVIEW;
        }
        String thumbnailUrl = URLUtil.getApplicationURL() + "/gallery/jsp/icons/" + this.getType().name().toLowerCase() + "_";
        switch (mediaResolution) {
            case TINY: {
                thumbnailUrl = thumbnailUrl + MediaResolution.TINY.getLabel();
                break;
            }
            case SMALL: {
                thumbnailUrl = thumbnailUrl + MediaResolution.SMALL.getLabel();
                break;
            }
            case WATERMARK: {
                return "";
            }
            default: {
                thumbnailUrl = thumbnailUrl + MediaResolution.MEDIUM.getLabel();
            }
        }
        thumbnailUrl = thumbnailUrl + ".png";
        return FilenameUtils.normalize((String)thumbnailUrl, (boolean)true);
    }

    public String getApplicationEmbedUrl(MediaResolution mediaResolution) {
        return GalleryResourceURIs.buildMediaEmbedURI(this, mediaResolution).toString();
    }

    public String getApplicationOriginalUrl() {
        if (StringUtil.isNotDefined((String)this.getId())) {
            return "";
        }
        return GalleryResourceURIs.buildMediaContentURI(this, MediaResolution.ORIGINAL).toString();
    }

    public SilverpeasFile getFile(MediaResolution mediaResolution) {
        return this.getFile(mediaResolution, null);
    }

    public abstract SilverpeasFile getFile(MediaResolution var1, String var2);

    public String getSilverpeasContentId() {
        return this.silverpeasContentId;
    }

    public void setSilverpeasContentId(String silverpeasContentId) {
        this.silverpeasContentId = silverpeasContentId;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public boolean isDownloadable() {
        return true;
    }

    public String getURL() {
        return "searchResult?Type=" + this.getType().name() + "&Id=" + this.getId();
    }

    public String getDate() {
        return DateUtil.date2SQLDate((Date)this.getLastUpdateDate());
    }

    public String getSilverCreationDate() {
        return DateUtil.date2SQLDate((Date)this.getCreationDate());
    }

    public String getName() {
        return this.getTitle();
    }

    public String getName(String language) {
        return this.getName();
    }

    public String getDescription(String language) {
        return this.getDescription();
    }

    public Collection<String> getLanguages() {
        return Collections.emptyList();
    }

    public String toString() {
        return "(pk = " + (this.getMediaPK() != null ? this.getMediaPK().toString() : "") + ", name = " + this.getTitle() + ")";
    }

    public boolean equals(Object o) {
        if (o instanceof Media) {
            Media anotherPhoto = (Media)o;
            return this.getMediaPK().equals((Object)anotherPhoto.getMediaPK());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 29).append((Object)this.getMediaPK()).append((Object)this.getTitle()).append((Object)this.getDescription()).append((Object)this.getPermalink()).toHashCode();
    }

    public InternalMedia getInternalMedia() {
        if (this instanceof InternalMedia) {
            return (InternalMedia)this;
        }
        return null;
    }

    public Photo getPhoto() {
        if (MediaType.Photo == this.getType()) {
            return (Photo)this;
        }
        return null;
    }

    public Video getVideo() {
        if (MediaType.Video == this.getType()) {
            return (Video)this;
        }
        return null;
    }

    public Sound getSound() {
        if (MediaType.Sound == this.getType()) {
            return (Sound)this;
        }
        return null;
    }

    public Streaming getStreaming() {
        if (MediaType.Streaming == this.getType()) {
            return (Streaming)this;
        }
        return null;
    }

    public void removeFromAllAlbums() {
        MediaServiceProvider.getMediaService().removeMediaFromAllAlbums(this);
    }

    public void addToAlbums(String ... albumIds) {
        MediaServiceProvider.getMediaService().addMediaToAlbums(this, albumIds);
    }

    public void setToAlbums(String ... albumIds) {
        Collection<String> previousAlbumIds = MediaServiceProvider.getMediaService().getAlbumIdsOf(this);
        List newAlbumIdsToNotify = Stream.of(albumIds).filter(i -> !previousAlbumIds.contains(i)).collect(Collectors.toList());
        List oldAlbumIdsToNotify = previousAlbumIds.stream().filter(i -> ArrayUtil.indexOf((Object[])albumIds, (Object)i) < 0).collect(Collectors.toList());
        this.removeFromAllAlbums();
        this.addToAlbums(albumIds);
        AlbumMediaEventNotifier notifier = AlbumMediaEventNotifier.get();
        for (String albumId : oldAlbumIdsToNotify) {
            notifier.notifyEventOn(ResourceEvent.Type.DELETION, new AlbumMedia[]{new AlbumMedia(albumId, this)});
        }
        for (String albumId : newAlbumIdsToNotify) {
            notifier.notifyEventOn(ResourceEvent.Type.CREATION, new AlbumMedia[]{new AlbumMedia(albumId, this)});
        }
    }

    protected SilverpeasRole getHighestUserRole(User user) {
        Set userRoles = SilverpeasRole.fromStrings((String[])OrganizationControllerProvider.getOrganisationController().getUserProfiles(user.getId(), this.getInstanceId()));
        return SilverpeasRole.getHighestFrom((Collection)userRoles);
    }

    public abstract Media getCopy();
}

