/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.blog.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.silverpeas.core.persistence.jdbc.DBUtil;

public class PostDAO {
    private static final FastDateFormat FORMATTER = FastDateFormat.getInstance((String)"yyyy/MM/dd");

    private PostDAO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDateEvent(Connection con, String pubId, Date dateEvent, String instanceId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "insert into SC_Blog_Post (pubId, dateEvent, instanceId) values (?, ?, ?)";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(pubId));
            prepStmt.setString(2, Long.toString(dateEvent.getTime()));
            prepStmt.setString(3, instanceId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDateEvent(Connection con, String pubId) throws SQLException {
        String query = "select dateEvent from SC_Blog_Post where pubId = ? ";
        Date dateEvent = new Date();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(pubId));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                dateEvent = new Date(Long.parseLong(rs.getString("dateEvent")));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return dateEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDateEvent(Connection con, String pubId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "delete from SC_Blog_Post where pubId = ? ";
            prepStmt = con.prepareStatement(query);
            prepStmt.setInt(1, Integer.parseInt(pubId));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDateEvent(Connection con, String pubId, Date dateEvent) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String query = "update SC_Blog_Post set dateEvent = ? where pubId = ?";
            prepStmt = con.prepareStatement(query);
            prepStmt.setString(1, "" + dateEvent.getTime());
            prepStmt.setInt(2, Integer.parseInt(pubId));
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getAllEvents(Connection con, String instanceId) throws SQLException {
        ArrayList<String> listEvents = new ArrayList<String>();
        String query = "select pubId from SC_Blog_Post where instanceId = ? order by dateEvent DESC, pubId DESC";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setString(1, instanceId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String pubId = String.valueOf(rs.getInt("pubId"));
                listEvents.add(pubId);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return listEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Date> getAllDateEvents(Connection con, String instanceId) throws SQLException {
        ArrayList<Date> dateEvents = null;
        String query = "select dateEvent from SC_Blog_Post where instanceId = ? order by dateEvent DESC";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setString(1, instanceId);
            rs = prepStmt.executeQuery();
            dateEvents = new ArrayList<Date>();
            while (rs.next()) {
                dateEvents.add(new Date(Long.parseLong(rs.getString("dateEvent"))));
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return dateEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getEventsByDates(Connection con, String instanceId, String beginDate, String endDate) throws SQLException, ParseException {
        ArrayList<String> listEvents = null;
        String query = "select pubId from SC_Blog_Post where instanceId = ? and dateEvent >= ? and dateEvent <= ? order by dateEvent DESC";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            prepStmt = con.prepareStatement(query);
            prepStmt.setString(1, instanceId);
            prepStmt.setString(2, Long.toString(FORMATTER.parse(beginDate).getTime()));
            prepStmt.setString(3, Long.toString(FORMATTER.parse(endDate).getTime()));
            rs = prepStmt.executeQuery();
            listEvents = new ArrayList<String>();
            while (rs.next()) {
                String pubId = "" + rs.getInt("pubId");
                listEvents.add(pubId);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, (Statement)prepStmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)rs, (Statement)prepStmt);
        return listEvents;
    }
}

