/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text.list;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListHeaderElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleBulletElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleImageElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.list.BulletDecorator;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.odftoolkit.simple.text.list.ListItem;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List {
    private TextListElement listElement;
    private ListDecorator decorator;

    List(TextListElement element) {
        this.listElement = element;
        this.decorator = null;
    }

    public List(ListContainer container) {
        this(container, null, null);
    }

    public List(ListContainer container, ListDecorator decorator) {
        this(container, null, decorator);
    }

    public List(ListContainer container, String header, ListDecorator decorator) {
        OdfElement containerElement = container.getListContainerElement();
        OdfFileDom ownerDocument = (OdfFileDom)containerElement.getOwnerDocument();
        this.listElement = (TextListElement)ownerDocument.newOdfElement(TextListElement.class);
        this.listElement.setXmlIdAttribute(this.getUniqueXMLID());
        containerElement.appendChild((Node)this.listElement);
        this.setHeader(header);
        if (decorator == null) {
            Document doc = (Document)ownerDocument.getDocument();
            decorator = new BulletDecorator(doc);
        }
        this.decorator = decorator;
        decorator.decorateList(this);
    }

    public List(ListContainer container, String header, boolean isContinueNumbering, ListDecorator decorator) {
        this(container, header, decorator);
        this.setContinueNumbering(isContinueNumbering);
    }

    public List(ListContainer container, String header, List continueList, ListDecorator decorator) {
        this(container, header, decorator);
        this.setContinueList(continueList);
    }

    public ListDecorator.ListType getType() {
        if (this.decorator != null) {
            return this.decorator.getListType();
        }
        try {
            String textStyleName = this.listElement.getTextStyleNameAttribute();
            Document doc = (Document)((OdfFileDom)this.listElement.getOwnerDocument()).getDocument();
            OdfContentDom contentDocument = doc.getContentDom();
            OdfOfficeAutomaticStyles styles = contentDocument.getAutomaticStyles();
            OdfOfficeStyles documentStyles = doc.getDocumentStyles();
            OdfTextListStyle listStyle = styles.getListStyle(textStyleName);
            if (listStyle == null) {
                listStyle = documentStyles.getListStyle(textStyleName);
            }
            if (listStyle != null) {
                TextListLevelStyleElementBase listLevelStyle = listStyle.getLevel(1);
                if (listLevelStyle instanceof TextListLevelStyleBulletElement) {
                    return ListDecorator.ListType.BULLET;
                }
                if (listLevelStyle instanceof TextListLevelStyleNumberElement) {
                    return ListDecorator.ListType.NUMBER;
                }
                if (listLevelStyle instanceof TextListLevelStyleImageElement) {
                    return ListDecorator.ListType.IMAGE;
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(List.class.getName()).log(Level.SEVERE, null, e);
        }
        return null;
    }

    public String getHeader() {
        String header = "";
        Node headerNode = this.listElement.getFirstChild();
        if (headerNode instanceof TextListHeaderElement) {
            String splitString = "";
            for (Node pNode = headerNode.getFirstChild(); pNode != null; pNode = pNode.getNextSibling()) {
                String content;
                if (!(pNode instanceof TextPElement) || (content = pNode.getTextContent()) == null || content.length() <= 0) continue;
                header = header + splitString + content;
                splitString = "\n";
            }
        }
        if ("".equals(header)) {
            return null;
        }
        return header;
    }

    public void setHeader(String header) {
        if (header != null) {
            String[] headerContents = header.split("\n");
            TextListHeaderElement listHeaderElement = null;
            Node firstNode = this.listElement.getFirstChild();
            if (firstNode instanceof TextListHeaderElement) {
                listHeaderElement = (TextListHeaderElement)firstNode;
                for (Node pElement = listHeaderElement.getFirstChild(); pElement != null; pElement = pElement.getNextSibling()) {
                    firstNode.removeChild(pElement);
                }
            } else {
                listHeaderElement = (TextListHeaderElement)((OdfFileDom)this.listElement.getOwnerDocument()).newOdfElement(TextListHeaderElement.class);
                this.listElement.insertBefore((Node)listHeaderElement, firstNode);
            }
            for (String headerContent : headerContents) {
                TextPElement pElement = listHeaderElement.newTextPElement();
                pElement.setTextContent(headerContent);
            }
        }
    }

    public void setDecorator(ListDecorator decorator) {
        if (decorator != null) {
            this.decorator = decorator;
            decorator.decorateList(this);
        }
    }

    public ListItem addItem(String itemContent) {
        TextListItemElement listItemElement = this.listElement.newTextListItemElement();
        ListItem item = new ListItem(listItemElement);
        item.setParagraphDecorator(this.decorator);
        item.setTextContent(itemContent);
        return item;
    }

    public ListItem addItem(int location, String itemContent) {
        OdfFileDom ownerDocument = (OdfFileDom)this.listElement.getOwnerDocument();
        TextListItemElement listItemElement = (TextListItemElement)ownerDocument.newOdfElement(TextListItemElement.class);
        TextListItemElement refNode = this.getItemByLocation(location);
        this.listElement.insertBefore((Node)listItemElement, (Node)refNode);
        ListItem item = new ListItem(listItemElement);
        item.setParagraphDecorator(this.decorator);
        item.setTextContent(itemContent);
        return item;
    }

    public ListItem addItem(ListItem item) {
        TextListItemElement itemElement = (TextListItemElement)item.getOdfElement().cloneNode(true);
        this.listElement.appendChild((Node)itemElement);
        ListItem newItem = new ListItem(itemElement);
        return newItem;
    }

    public ListItem addItem(int location, ListItem item) {
        TextListItemElement itemElement = (TextListItemElement)item.getOdfElement().cloneNode(true);
        TextListItemElement refNode = this.getItemByLocation(location);
        this.listElement.insertBefore((Node)itemElement, (Node)refNode);
        ListItem newItem = new ListItem(itemElement);
        return newItem;
    }

    public java.util.List<ListItem> addItems(String[] items) {
        ArrayList<ListItem> itemList = new ArrayList<ListItem>();
        for (String itemString : items) {
            TextListItemElement listItemElement = this.listElement.newTextListItemElement();
            ListItem item = new ListItem(listItemElement);
            item.setTextContent(itemString);
            itemList.add(item);
        }
        return itemList;
    }

    public java.util.List<ListItem> addItems(int location, String[] items) {
        ArrayList<ListItem> listCollection = new ArrayList<ListItem>();
        OdfFileDom ownerDocument = (OdfFileDom)this.listElement.getOwnerDocument();
        TextListItemElement refNode = this.getItemByLocation(location);
        for (int i = items.length - 1; i >= 0; --i) {
            TextListItemElement listItemElement = (TextListItemElement)ownerDocument.newOdfElement(TextListItemElement.class);
            this.listElement.insertBefore((Node)listItemElement, (Node)refNode);
            ListItem item = new ListItem(listItemElement);
            item.setParagraphDecorator(this.decorator);
            item.setTextContent(items[i]);
            refNode = listItemElement;
            listCollection.add(item);
        }
        return listCollection;
    }

    public java.util.List<ListItem> addItems(ListItem[] items) {
        ArrayList<ListItem> itemList = new ArrayList<ListItem>();
        for (ListItem itemClone : items) {
            TextListItemElement itemElement = (TextListItemElement)itemClone.getOdfElement().cloneNode(true);
            this.listElement.appendChild((Node)itemElement);
            itemList.add(new ListItem(itemElement));
        }
        return itemList;
    }

    public java.util.List<ListItem> addItems(int location, ListItem[] items) {
        ArrayList<ListItem> listCollection = new ArrayList<ListItem>();
        TextListItemElement refNode = this.getItemByLocation(location);
        for (int i = items.length - 1; i >= 0; --i) {
            TextListItemElement itemElement = (TextListItemElement)items[i].getOdfElement().cloneNode(true);
            this.listElement.insertBefore((Node)itemElement, (Node)refNode);
            ListItem item = new ListItem(itemElement);
            refNode = itemElement;
            listCollection.add(item);
        }
        return listCollection;
    }

    public ListItem getItem(int location) {
        return new ListItem(this.getItemByLocation(location));
    }

    public java.util.List<ListItem> getItems() {
        ArrayList<ListItem> itemList = new ArrayList<ListItem>();
        for (Node firstNode = this.listElement.getFirstChild(); firstNode != null; firstNode = firstNode.getNextSibling()) {
            if (!(firstNode instanceof TextListItemElement)) continue;
            itemList.add(new ListItem((TextListItemElement)firstNode));
        }
        return itemList;
    }

    public int size() {
        int size = 0;
        for (Node firstNode = this.listElement.getFirstChild(); firstNode != null; firstNode = firstNode.getNextSibling()) {
            if (!(firstNode instanceof TextListItemElement)) continue;
            ++size;
        }
        return size;
    }

    public ListItem set(int location, ListItem item) {
        TextListItemElement itemElement = (TextListItemElement)item.getOdfElement().cloneNode(true);
        TextListItemElement oldNode = this.getItemByLocation(location);
        this.listElement.replaceChild((Node)itemElement, (Node)oldNode);
        ListItem newItem = new ListItem(itemElement);
        newItem.setParagraphDecorator(this.decorator);
        return newItem;
    }

    public ListItem set(int location, String itemContent) {
        OdfFileDom ownerDocument = (OdfFileDom)this.listElement.getOwnerDocument();
        TextListItemElement listItemElement = (TextListItemElement)ownerDocument.newOdfElement(TextListItemElement.class);
        TextListItemElement oldNode = this.getItemByLocation(location);
        this.listElement.replaceChild((Node)listItemElement, (Node)oldNode);
        ListItem item = new ListItem(listItemElement);
        item.setParagraphDecorator(this.decorator);
        item.setTextContent(itemContent);
        return item;
    }

    public boolean removeItem(int location) {
        TextListItemElement itemElement = this.getItemByLocation(location);
        if (itemElement == null) {
            return false;
        }
        OdfFileDom ownerDocument = (OdfFileDom)this.listElement.getOwnerDocument();
        Document doc = (Document)ownerDocument.getDocument();
        doc.removeElementLinkedResource((OdfElement)itemElement);
        this.listElement.removeChild((Node)itemElement);
        return true;
    }

    public boolean removeItem(ListItem item) {
        TextListItemElement itemElement = item.getOdfElement();
        OdfFileDom ownerDocument = (OdfFileDom)this.listElement.getOwnerDocument();
        Document doc = (Document)ownerDocument.getDocument();
        doc.removeElementLinkedResource((OdfElement)itemElement);
        Node removedNode = this.listElement.removeChild((Node)itemElement);
        return removedNode != null;
    }

    public boolean removeItems(java.util.List<ListItem> items) {
        boolean listChanged = false;
        for (ListItem item : items) {
            TextListItemElement itemElement = item.getOdfElement();
            OdfFileDom ownerDocument = (OdfFileDom)this.listElement.getOwnerDocument();
            Document doc = (Document)ownerDocument.getDocument();
            doc.removeElementLinkedResource((OdfElement)itemElement);
            Node removedNode = this.listElement.removeChild((Node)itemElement);
            if (removedNode == null) continue;
            listChanged = true;
        }
        return listChanged;
    }

    public void clear() {
        Node firstChild = this.listElement.getFirstChild();
        while (firstChild != null) {
            if (firstChild instanceof TextListItemElement) {
                Node removedNode = firstChild;
                firstChild = firstChild.getNextSibling();
                this.listElement.removeChild(removedNode);
                continue;
            }
            firstChild = firstChild.getNextSibling();
        }
    }

    public void remove() {
        Node parentElement = this.listElement.getParentNode();
        OdfFileDom ownerDocument = (OdfFileDom)this.listElement.getOwnerDocument();
        Document doc = (Document)ownerDocument.getDocument();
        doc.removeElementLinkedResource((OdfElement)this.listElement);
        parentElement.removeChild((Node)this.listElement);
    }

    public boolean isContinueNumbering() {
        Boolean isContinueNumbering = this.listElement.getTextContinueNumberingAttribute();
        if (isContinueNumbering == null) {
            String continueList = this.listElement.getTextContinueListAttribute();
            return continueList != null;
        }
        return isContinueNumbering;
    }

    public void setContinueNumbering(boolean isContinueNumbering) {
        if (this.getType() == ListDecorator.ListType.NUMBER) {
            this.listElement.setTextContinueNumberingAttribute(Boolean.valueOf(isContinueNumbering));
        }
    }

    public List getContinueList() {
        List continueList = null;
        if (this.isContinueNumbering()) {
            TextListElement continueListElement = null;
            String continueListID = this.listElement.getTextContinueListAttribute();
            if (continueListID != null) {
                Node parentElement = this.listElement.getParentNode();
                for (Node firstNode = parentElement.getFirstChild(); firstNode != null; firstNode = firstNode.getNextSibling()) {
                    TextListElement listElement;
                    String xmlID;
                    if (!(firstNode instanceof TextListElement) || !continueListID.equals(xmlID = (listElement = (TextListElement)firstNode).getXmlIdAttribute())) continue;
                    continueListElement = (TextListElement)firstNode;
                    break;
                }
            } else {
                for (Node preNode = this.listElement.getPreviousSibling(); preNode != null; preNode = preNode.getPreviousSibling()) {
                    if (!(preNode instanceof TextListElement)) continue;
                    continueListElement = (TextListElement)preNode;
                    break;
                }
            }
            continueList = new List(continueListElement);
        }
        return continueList;
    }

    public void setContinueList(List continueList) {
        if (this.getType() == ListDecorator.ListType.NUMBER) {
            String xmlId = continueList.listElement.getXmlIdAttribute();
            if (xmlId != null) {
                this.listElement.setTextContinueListAttribute(xmlId);
            } else {
                xmlId = this.getUniqueXMLID();
                continueList.listElement.setXmlIdAttribute(xmlId);
                this.listElement.setTextContinueListAttribute(xmlId);
            }
            this.listElement.setTextContinueNumberingAttribute(Boolean.valueOf(true));
        }
    }

    public int getLevel() {
        int level = 1;
        for (Node parentNode = this.listElement.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            if (parentNode instanceof TextListElement) {
                ++level;
            }
            if (parentNode instanceof TableTableCellElementBase) break;
        }
        return level;
    }

    public TextListElement getOdfElement() {
        return this.listElement;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        int level = this.getLevel();
        String levelPrefix = "";
        for (int i = 1; i < level; ++i) {
            levelPrefix = levelPrefix + " ";
        }
        String splitStr = "";
        String header = this.getHeader();
        if (header != null) {
            strBuilder.append(levelPrefix);
            strBuilder.append(header);
            splitStr = "\n";
        }
        String itemPrefix = "\u2022 ";
        int j = 0;
        if (this.getType() == ListDecorator.ListType.NUMBER) {
            itemPrefix = ". ";
            j = 1;
        }
        for (ListItem item : this.getItems()) {
            strBuilder.append(splitStr);
            strBuilder.append(levelPrefix);
            if (j > 0) {
                strBuilder.append(j++);
            }
            strBuilder.append(itemPrefix);
            strBuilder.append(item.toString());
            splitStr = "\n";
        }
        return strBuilder.toString();
    }

    private TextListItemElement getItemByLocation(int location) {
        Node firstNode;
        if (location < 0) {
            throw new IndexOutOfBoundsException("the location " + location + " is is out of the List range.");
        }
        TextListItemElement positionNode = null;
        int i = 0;
        for (firstNode = this.listElement.getFirstChild(); firstNode != null; firstNode = firstNode.getNextSibling()) {
            if (!(firstNode instanceof TextListItemElement)) continue;
            if (i == location) break;
            ++i;
        }
        if (i == location && firstNode instanceof TextListItemElement) {
            positionNode = (TextListItemElement)firstNode;
        }
        if (location != 0 && i < location) {
            throw new IndexOutOfBoundsException("the location " + location + " is is out of the List range.");
        }
        return positionNode;
    }

    private String getUniqueXMLID() {
        return "list" + Math.round(Math.random() * 1.0E8);
    }
}

