/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.whitepages.control;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.components.whitepages.WhitePagesException;
import org.silverpeas.components.whitepages.control.WhitePagesContentManager;
import org.silverpeas.components.whitepages.model.Card;
import org.silverpeas.components.whitepages.model.SilverCard;
import org.silverpeas.components.whitepages.model.WhitePagesCard;
import org.silverpeas.components.whitepages.record.UserRecord;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.template.publication.PublicationTemplate;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.persistence.jdbc.bean.PersistenceException;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAO;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanDAOFactory;
import org.silverpeas.core.persistence.jdbc.bean.SilverpeasBeanIntf;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.logging.SilverLogger;

@Service
public class CardManager {
    @Inject
    private WhitePagesContentManager contentManager = null;

    protected CardManager() {
    }

    private WhitePagesContentManager getWhitePagesContentManager() {
        return this.contentManager;
    }

    public static CardManager getInstance() {
        return (CardManager)ServiceProvider.getService(CardManager.class, (Annotation[])new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long create(Card card, String creatorId, PdcClassification classification) throws WhitePagesException {
        long id = -1L;
        Connection con = null;
        try {
            SilverpeasBeanDAO dao = this.getCardDAO();
            con = DBUtil.openConnection();
            con.setAutoCommit(false);
            card.setCreationDate(DateUtil.date2SQLDate((Date)new Date()));
            card.setCreatorId(Integer.parseInt(creatorId));
            WAPrimaryKey pk = dao.add(con, (SilverpeasBeanIntf)card);
            id = Long.parseLong(pk.getId());
            card.setPK(pk);
            int silverContentId = this.getWhitePagesContentManager().createSilverContent(con, card);
            this.indexCard(card);
            con.commit();
            if (classification != null && !classification.isEmpty()) {
                SilverCard silverCard = new SilverCard(card, silverContentId);
                classification.classifyContent((Contribution)silverCard);
            }
        }
        catch (Exception e) {
            this.rollback(con, e);
        }
        finally {
            this.closeConnection(con);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Collection<String> ids) throws WhitePagesException {
        Connection con = null;
        if (ids != null) {
            try {
                con = DBUtil.openConnection();
                con.setAutoCommit(false);
                SilverpeasBeanDAO dao = this.getCardDAO();
                IdPK pk = new IdPK();
                String peasId = null;
                for (String id : ids) {
                    pk.setId(id);
                    if (peasId == null) {
                        Card card = this.getCard(Long.parseLong(pk.getId()));
                        if (card == null) continue;
                        peasId = card.getInstanceId();
                    }
                    dao.remove(con, (WAPrimaryKey)pk);
                    pk.setComponentName(peasId);
                    this.getWhitePagesContentManager().deleteSilverContent(con, pk);
                    con.commit();
                    this.deleteIndex((WAPrimaryKey)pk);
                }
            }
            catch (Exception e) {
                this.rollback(con, e);
            }
            finally {
                this.closeConnection(con);
            }
        }
    }

    public Card getCard(long id) throws WhitePagesException {
        Card result;
        IdPK pk = new IdPK();
        try {
            SilverpeasBeanDAO dao = this.getCardDAO();
            pk.setIdAsLong(id);
            result = (Card)dao.findByPrimaryKey((WAPrimaryKey)pk);
        }
        catch (PersistenceException e) {
            throw new WhitePagesException("CardManager.getCard", 4, "whitePages.EX_CANT_GET_CARD", "", (Exception)((Object)e));
        }
        return result;
    }

    public Collection<Card> getCards(String instanceId) throws WhitePagesException {
        Collection cards;
        String where = " instanceId = '" + instanceId + "'";
        try {
            IdPK pk = new IdPK();
            SilverpeasBeanDAO dao = this.getCardDAO();
            cards = dao.findByWhereClause((WAPrimaryKey)pk, where);
        }
        catch (PersistenceException e) {
            throw new WhitePagesException("CardManager.getCards", 4, "whitePages.EX_CANT_GET_CARDS", "", (Exception)((Object)e));
        }
        return cards;
    }

    public Collection<Card> getCardsByIds(List<String> ids) throws WhitePagesException {
        Collection cards;
        StringBuilder where = new StringBuilder();
        int sizeOfIds = ids.size();
        for (int i = 0; i < sizeOfIds - 1; ++i) {
            where.append(" id = ").append(ids.get(i)).append(" or ");
        }
        if (sizeOfIds != 0) {
            where.append(" id = ").append(ids.get(sizeOfIds - 1));
        }
        try {
            IdPK pk = new IdPK();
            SilverpeasBeanDAO dao = this.getCardDAO();
            cards = dao.findByWhereClause((WAPrimaryKey)pk, where.toString());
        }
        catch (PersistenceException e) {
            throw new WhitePagesException("CardManager.getCards", 4, "whitePages.EX_CANT_GET_CARDS", "", (Exception)((Object)e));
        }
        return cards;
    }

    public Collection<Card> getVisibleCards(String instanceId) throws WhitePagesException {
        Collection cards;
        String where = " instanceId = '" + instanceId + "' and hideStatus = 0";
        try {
            IdPK pk = new IdPK();
            SilverpeasBeanDAO dao = this.getCardDAO();
            cards = dao.findByWhereClause((WAPrimaryKey)pk, where);
        }
        catch (PersistenceException e) {
            throw new WhitePagesException("CardManager.getVisibleCards", 4, "whitePages.EX_CANT_GET_CARDS", "", (Exception)((Object)e));
        }
        return cards;
    }

    public Collection<WhitePagesCard> getUserCards(String userId, Collection<String> instanceIds) throws WhitePagesException {
        Iterator<String> it;
        StringBuilder where = new StringBuilder(" userId = '" + userId + "' and hideStatus = 0");
        if (instanceIds != null && (it = instanceIds.iterator()).hasNext()) {
            where.append(" and instanceId IN (");
            String id = it.next();
            where.append("'").append(id).append("'");
            for (String appId : instanceIds) {
                where.append(", '").append(appId).append("'");
            }
            where.append(")");
            return this.getWhitePagesCards(where.toString());
        }
        return new ArrayList<WhitePagesCard>();
    }

    public Collection<WhitePagesCard> getHomeUserCards(String userId, Collection<String> instanceIds, String instanceId) throws WhitePagesException {
        Iterator<String> it;
        StringBuilder where = new StringBuilder(" userId = '" + userId + "' and ((instanceId = '" + instanceId + "') or (hideStatus = 0");
        if (instanceIds != null && !instanceIds.isEmpty() && (it = instanceIds.iterator()).hasNext()) {
            where.append(" and instanceId IN (");
            String id = it.next();
            where.append("'").append(id).append("'");
            for (String appId : instanceIds) {
                where.append(", '").append(appId).append("'");
            }
            where.append(")))");
            return this.getWhitePagesCards(where.toString());
        }
        return new ArrayList<WhitePagesCard>();
    }

    private Collection<WhitePagesCard> getWhitePagesCards(String whereClause) throws WhitePagesException {
        ArrayList<WhitePagesCard> wpcards = new ArrayList<WhitePagesCard>();
        try {
            IdPK pk = new IdPK();
            SilverpeasBeanDAO dao = this.getCardDAO();
            Collection cards = dao.findByWhereClause((WAPrimaryKey)pk, whereClause);
            if (cards != null) {
                for (Card card : cards) {
                    wpcards.add(new WhitePagesCard(Long.parseLong(card.getPK().getId()), card.getInstanceId()));
                }
            }
        }
        catch (PersistenceException e) {
            throw new WhitePagesException("CardManager.getWhitePagesCards", 4, "whitePages.EX_CANT_GET_USERCARDS", "", (Exception)((Object)e));
        }
        return wpcards;
    }

    public void setHideStatus(Collection<String> ids, int status) throws WhitePagesException {
        if (ids != null) {
            try {
                SilverpeasBeanDAO dao = this.getCardDAO();
                for (String sId : ids) {
                    long id = Long.parseLong(sId);
                    IdPK pk = new IdPK();
                    pk.setIdAsLong(id);
                    Card card = (Card)dao.findByPrimaryKey((WAPrimaryKey)pk);
                    card.setHideStatus(status);
                    dao.update((SilverpeasBeanIntf)card);
                    card.getPK().setComponentName(card.getInstanceId());
                    this.getWhitePagesContentManager().updateSilverContentVisibility(card);
                }
            }
            catch (Exception e) {
                throw new WhitePagesException("CardManager.setHideStatus", 4, "whitePages.EX_UPDATE_CARDS_FAILED", "", e);
            }
        }
    }

    public void reverseHide(Collection<String> ids) throws WhitePagesException {
        if (ids != null) {
            try {
                SilverpeasBeanDAO dao = this.getCardDAO();
                for (String sId : ids) {
                    long id = Long.parseLong(sId);
                    IdPK pk = new IdPK();
                    pk.setIdAsLong(id);
                    Card card = (Card)dao.findByPrimaryKey((WAPrimaryKey)pk);
                    int status = card.getHideStatus();
                    status = status == 0 ? 1 : 0;
                    card.setHideStatus(status);
                    dao.update((SilverpeasBeanIntf)card);
                    card.getPK().setComponentName(card.getInstanceId());
                    this.getWhitePagesContentManager().updateSilverContentVisibility(card);
                }
            }
            catch (Exception e) {
                throw new WhitePagesException("CardManager.reverseHide", 4, "whitePages.EX_UPDATE_CARDS_FAILED", "", e);
            }
        }
    }

    public boolean existCard(String userId, String instanceId) throws WhitePagesException {
        String where = " instanceId = '" + instanceId + "' and userId = '" + userId + "'";
        boolean exist = false;
        try {
            IdPK pk = new IdPK();
            SilverpeasBeanDAO dao = this.getCardDAO();
            Collection cards = dao.findByWhereClause((WAPrimaryKey)pk, where);
            if (cards != null && !cards.isEmpty()) {
                exist = true;
            }
        }
        catch (PersistenceException e) {
            throw new WhitePagesException("CardManager.existCard", 4, "whitePages.EX_CANT_GET_CARDS", "", (Exception)((Object)e));
        }
        return exist;
    }

    public boolean isPublicationClassifiedOnPDC(Card card) throws ContentManagerException, PdcException {
        ContentManagementEngine contentMgtEngine = ContentManagementEngineProvider.getContentManagementEngine();
        int contentId = contentMgtEngine.getSilverContentId(card.getPK().getId(), card.getInstanceId());
        PdcManager pdcManager = PdcManager.get();
        List positions = pdcManager.getPositions(contentId, card.getInstanceId());
        return !positions.isEmpty();
    }

    public Card getUserCard(String userId, String instanceId) throws WhitePagesException {
        String where = " instanceId = '" + instanceId + "' and userId = '" + userId + "'";
        Card card = null;
        try {
            IdPK pk = new IdPK();
            SilverpeasBeanDAO dao = this.getCardDAO();
            Collection cards = dao.findByWhereClause((WAPrimaryKey)pk, where);
            if (cards != null && !cards.isEmpty()) {
                card = (Card)((Object)cards.iterator().next());
            }
        }
        catch (PersistenceException e) {
            throw new WhitePagesException("CardManager.getUserCard", 4, "whitePages.EX_CANT_GET_CARDS", "", (Exception)((Object)e));
        }
        return card;
    }

    public void indexCard(Card card) {
        WAPrimaryKey pk = card.getPK();
        String userName = this.extractUserName(card);
        String userMail = this.extractUserMail(card);
        FullIndexEntry indexEntry = new FullIndexEntry(card.getInstanceId(), "card", pk.getId());
        indexEntry.setTitle(userName);
        indexEntry.setKeywords(userName);
        indexEntry.setPreview(userMail);
        try {
            indexEntry.setCreationDate(DateUtil.parse((String)card.getCreationDate()));
        }
        catch (ParseException e) {
            SilverLogger.getLogger((Object)this).warn((Throwable)e);
        }
        indexEntry.setCreationUser(Integer.toString(card.getCreatorId()));
        try {
            PublicationTemplate pub = PublicationTemplateManager.getInstance().getPublicationTemplate(card.getInstanceId());
            String xmlFormShortName = pub.getFileName().substring(pub.getFileName().indexOf("/") + 1, pub.getFileName().indexOf("."));
            RecordSet set = pub.getRecordSet();
            set.indexRecord(pk.getId(), xmlFormShortName, indexEntry);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("User card indexation failure", (Throwable)e);
        }
        IndexEngineProxy.addIndexEntry((FullIndexEntry)indexEntry);
    }

    private void deleteIndex(WAPrimaryKey pk) {
        IndexEngineProxy.removeIndexEntry((IndexEntryKey)new IndexEntryKey(pk.getComponentName(), "card", pk.getId()));
    }

    private String extractUserName(Card card) {
        StringBuilder text = new StringBuilder("");
        UserRecord user = card.readUserRecord();
        if (user != null) {
            Field f;
            try {
                f = user.getField("FirstName");
                text.append(f.getStringValue());
                text.append(" ");
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
            try {
                f = user.getField("LastName");
                text.append(f.getStringValue());
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
        }
        return text.toString();
    }

    private String extractUserMail(Card card) {
        StringBuilder text = new StringBuilder("");
        UserRecord user = card.readUserRecord();
        if (user != null) {
            try {
                Field f = user.getField("Mail");
                text.append(f.getStringValue());
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)this).warn((Throwable)e);
            }
        }
        return text.toString();
    }

    private void rollback(Connection con, Exception e) throws WhitePagesException {
        try {
            con.rollback();
        }
        catch (Exception e1) {
            throw new WhitePagesException("CardManager.create", 4, "whitePages.EX_CREATE_CARD_FAILED", "Error in rollback", e1);
        }
        throw new WhitePagesException("CardManager.create", 4, "whitePages.EX_CREATE_CARD_FAILED", "", e);
    }

    private void closeConnection(Connection con) throws WhitePagesException {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                throw new WhitePagesException("CardManager.create", 4, "whitePages.EX_CREATE_CARD_FAILED", "", e);
            }
        }
    }

    private SilverpeasBeanDAO getCardDAO() throws PersistenceException {
        return SilverpeasBeanDAOFactory.getDAO((String)"org.silverpeas.components.whitepages.model.Card");
    }
}

