/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.service;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.components.gallery.model.GalleryRuntimeException;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.service.MediaServiceProvider;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.core.util.Link;
import org.silverpeas.core.util.LocalizationBundle;
import org.silverpeas.core.util.ResourceLocator;
import org.silverpeas.core.util.SettingBundle;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.logging.SilverLogger;

public class ScheduledAlertUser
implements SchedulerEventListener {
    public static final String GALLERYENGINE_JOB_NAME = "GalleryEngineJob";

    public void initialize() {
        try {
            SettingBundle resources = ResourceLocator.getSettingBundle((String)"org.silverpeas.gallery.settings.gallerySettings");
            String cron = resources.getString("cronScheduledAlertUser");
            Scheduler scheduler = SchedulerProvider.getVolatileScheduler();
            scheduler.unscheduleJob(GALLERYENGINE_JOB_NAME);
            JobTrigger trigger = JobTrigger.triggerAt((String)cron);
            scheduler.scheduleJob(GALLERYENGINE_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("can not initialize successfully the batch in charge of alerting administrators about the end of visibility of media", (Throwable)e);
        }
    }

    public void doScheduledAlertUser() {
        try {
            SettingBundle resources = ResourceLocator.getSettingBundle((String)"org.silverpeas.gallery.settings.gallerySettings");
            int nbDays = resources.getInteger("nbDaysForAlertUser");
            Collection<Media> mediaList = MediaServiceProvider.getMediaService().getAllMediaThatWillBeNotVisible(nbDays);
            String currentInstanceId = null;
            LocalizedContent messageContent = new LocalizedContent();
            for (Media media : mediaList) {
                if (!media.getInstanceId().equals(currentInstanceId)) {
                    if (currentInstanceId != null) {
                        this.createMessage(messageContent, currentInstanceId);
                        messageContent = new LocalizedContent();
                    }
                    currentInstanceId = media.getInstanceId();
                }
                messageContent.appendFromBundleKey("gallery.notifName").append(" : ").append(media.getName()).append("\n");
            }
            if (currentInstanceId != null) {
                this.createMessage(messageContent, currentInstanceId);
            }
        }
        catch (Exception e) {
            throw new GalleryRuntimeException(e);
        }
    }

    private void createMessage(LocalizedContent localizedContent, String componentInstanceId) {
        UserDetail[] admins = (UserDetail[])OrganizationControllerProvider.getOrganisationController().getUsers("-1", componentInstanceId, "admin");
        if (admins == null || admins.length == 0) {
            return;
        }
        NotificationMetaData notificationMetaData = new NotificationMetaData(0, "", "");
        localizedContent.append("\n").appendFromBundleKey("gallery.notifUserInfo").append("\n\n");
        this.mergeLocalizedContentIntoNotificationMetaData(componentInstanceId, localizedContent, notificationMetaData);
        notificationMetaData.setComponentId(componentInstanceId);
        for (UserDetail admin : admins) {
            notificationMetaData.addUserRecipient(new UserRecipient((User)admin));
        }
        NotificationSender notifSender = new NotificationSender(componentInstanceId);
        try {
            notifSender.notifyUser(notificationMetaData);
        }
        catch (NotificationException e) {
            SilverLogger.getLogger((Object)this).error("can not send the notification message about media which will be no more visible", (Throwable)e);
        }
    }

    private void mergeLocalizedContentIntoNotificationMetaData(String componentInstanceId, LocalizedContent localizedContent, NotificationMetaData notificationMetaData) {
        String nameInstance = OrganizationControllerProvider.getOrganisationController().getComponentInst(componentInstanceId).getLabel();
        String url = URLUtil.getComponentInstanceURL((String)componentInstanceId) + "Main";
        for (String language : DisplayI18NHelper.getLanguages()) {
            LocalizationBundle bundle = LocalizedContent.getBundle(language);
            String subject = bundle.getString("gallery.notifSubject");
            String body = MessageFormat.format("{0} <b>{1}</b>\n\n{2}", bundle.getString("gallery.notifTitle"), nameInstance, localizedContent.get(language));
            notificationMetaData.addLanguage(language, subject, body);
            Link link = new Link(url, nameInstance);
            notificationMetaData.setLink(link, language);
        }
    }

    public void triggerFired(SchedulerEvent anEvent) {
        this.doScheduledAlertUser();
    }

    public void jobSucceeded(SchedulerEvent anEvent) {
    }

    public void jobFailed(SchedulerEvent anEvent) {
        SilverLogger.getLogger((Object)this).error("The job '" + anEvent.getJobExecutionContext().getJobName() + "' was not successfull", anEvent.getJobThrowable());
    }

    private static class LocalizedContent {
        private Map<String, StringBuilder> localizedContents = new HashMap<String, StringBuilder>();

        private LocalizedContent() {
        }

        public LocalizedContent appendFromBundleKey(String key) {
            for (String language : DisplayI18NHelper.getLanguages()) {
                LocalizedContent.append(this.localizedContents, language, LocalizedContent.getBundle(language).getString(key));
            }
            return this;
        }

        public LocalizedContent append(String content) {
            for (String language : DisplayI18NHelper.getLanguages()) {
                LocalizedContent.append(this.localizedContents, language, content);
            }
            return this;
        }

        static LocalizationBundle getBundle(String language) {
            return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.gallery.multilang.galleryBundle", (String)language);
        }

        private static void append(Map<String, StringBuilder> container, String language, String message) {
            StringBuilder sb = container.computeIfAbsent(language, l -> new StringBuilder());
            sb.append(message);
        }

        public String get(String language) {
            StringBuilder sb = this.localizedContents.get(language);
            return sb != null ? sb.toString() : "";
        }
    }
}

