/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.dao;

import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.silverpeas.components.gallery.constant.MediaMimeType;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.dao.MediaSQLQueryBuilder;
import org.silverpeas.components.gallery.model.InternalMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.model.MediaWithStatus;
import org.silverpeas.components.gallery.model.Photo;
import org.silverpeas.components.gallery.model.Sound;
import org.silverpeas.components.gallery.model.Streaming;
import org.silverpeas.components.gallery.model.Video;
import org.silverpeas.components.gallery.socialnetwork.SocialInformationGallery;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.io.media.Definition;
import org.silverpeas.core.media.streaming.StreamingProvider;
import org.silverpeas.core.media.streaming.StreamingProvidersRegistry;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQueries;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.persistence.jdbc.sql.ResultSetWrapper;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.logging.SilverLogger;

public class MediaDAO {
    private static final String GALLERY_PATH_TABLE = "SC_Gallery_Path";
    private static final String SELECT_INTERNAL_MEDIA_PREFIX = "I.mediaId, I.fileName, I.fileSize, I.fileMimeType, I.download, I.beginDownloadDate, I.endDownloadDate, ";
    private static final String GALLERY_MEDIA_TABLE = "SC_Gallery_Media";
    private static final String GALLERY_PHOTO_TABLE = "SC_Gallery_Photo";
    private static final String GALLERY_VIDEO_TABLE = "SC_Gallery_Video";
    private static final String GALLERY_SOUND_TABLE = "SC_Gallery_Sound";
    private static final String GALLERY_STREAMING_TABLE = "SC_Gallery_Streaming";
    private static final String GALLERY_INTERNAL_TABLE = "SC_Gallery_Internal";
    private static final String MEDIA_ID_CRITERIA = "mediaId = ?";
    private static final String MEDIA_ID_PARAM = "mediaId";
    private static final String INSTANCE_ID_PARAM = "instanceId";

    private MediaDAO() {
    }

    public static Media getByCriteria(MediaCriteria criteria) throws SQLException {
        return (Media)JdbcSqlQuery.unique(MediaDAO.findByCriteria(criteria));
    }

    public static List<Media> findByCriteria(MediaCriteria criteria) throws SQLException {
        MediaSQLQueryBuilder queryBuilder = MediaSQLQueryBuilder.selectBuilder();
        criteria.processWith(queryBuilder);
        JdbcSqlQuery selectQuery = queryBuilder.result();
        HashMap<String, Photo> photos = new HashMap<String, Photo>();
        HashMap<String, Video> videos = new HashMap<String, Video>();
        HashMap<String, Sound> sounds = new HashMap<String, Sound>();
        HashMap<String, Streaming> streamings = new HashMap<String, Streaming>();
        ListSlice media = selectQuery.execute(row -> {
            String mediaId = row.getString(1);
            MediaType mediaType = MediaType.from(row.getString(2));
            String instanceId = row.getString(3);
            MediaInfo mediaInfo = new MediaInfo(mediaId, mediaType, instanceId);
            return MediaDAO.fetchCurrentMedia(photos, videos, sounds, streamings, row, mediaInfo);
        });
        MediaDAO.decoratePhotos((List<Media>)media, photos);
        MediaDAO.decorateVideos((List<Media>)media, videos);
        MediaDAO.decorateSounds((List<Media>)media, sounds);
        MediaDAO.decorateStreamings((List<Media>)media, streamings);
        return queryBuilder.orderingResult((List<Media>)media);
    }

    private static Media fetchCurrentMedia(Map<String, Photo> photos, Map<String, Video> videos, Map<String, Sound> sounds, Map<String, Streaming> streaming, ResultSetWrapper row, MediaInfo mediaInfo) throws SQLException {
        Media currentMedia;
        switch (mediaInfo.getMediaType()) {
            case Photo: {
                currentMedia = new Photo();
                photos.put(mediaInfo.getMediaId(), (Photo)currentMedia);
                break;
            }
            case Video: {
                currentMedia = new Video();
                videos.put(mediaInfo.getMediaId(), (Video)currentMedia);
                break;
            }
            case Sound: {
                currentMedia = new Sound();
                sounds.put(mediaInfo.getMediaId(), (Sound)currentMedia);
                break;
            }
            case Streaming: {
                currentMedia = new Streaming();
                streaming.put(mediaInfo.getMediaId(), (Streaming)currentMedia);
                break;
            }
            default: {
                currentMedia = null;
            }
        }
        if (currentMedia == null) {
            SilverLogger.getLogger(MediaDAO.class).warn("Unknown media type {0}", new Object[]{mediaInfo.getMediaType()});
            return null;
        }
        currentMedia.setMediaPK(new MediaPK(mediaInfo.getMediaId(), mediaInfo.getInstanceId()));
        currentMedia.setTitle(row.getString(4));
        currentMedia.setDescription(row.getString(5));
        currentMedia.setAuthor(row.getString(6));
        currentMedia.setKeyWord(row.getString(7));
        currentMedia.setVisibilityPeriod(Period.check((Period)Period.from((Date)new Date(row.getLong(8)), (Date)new Date(row.getLong(9)))));
        currentMedia.setCreationDate(row.getTimestamp(10));
        currentMedia.setCreatorId(row.getString(11));
        currentMedia.setLastUpdateDate(row.getTimestamp(12));
        currentMedia.setLastUpdatedBy(row.getString(13));
        return currentMedia;
    }

    private static void decoratePhotos(List<Media> media, Map<String, Photo> photos) throws SQLException {
        if (!photos.isEmpty()) {
            Collection idGroups = CollectionUtil.split(new ArrayList<String>(photos.keySet()));
            String queryBase = "I.mediaId, I.fileName, I.fileSize, I.fileMimeType, I.download, I.beginDownloadDate, I.endDownloadDate, P.resolutionW, P.resolutionH from SC_Gallery_Internal I join SC_Gallery_Photo P on I.mediaId = P.mediaId where I.mediaId";
            for (Collection mediaIds : idGroups) {
                JdbcSqlQuery.createSelect((String)queryBase, (Object[])new Object[0]).in(mediaIds).execute(row -> {
                    String mediaId = row.getString(1);
                    mediaIds.remove(mediaId);
                    Photo currentPhoto = (Photo)photos.get(mediaId);
                    MediaDAO.decorateInternalMedia(row, currentPhoto);
                    currentPhoto.setDefinition(Definition.of((int)row.getInt(8), (int)row.getInt(9)));
                    return null;
                });
                for (String mediaIdNotFound : mediaIds) {
                    Photo currentPhoto = photos.remove(mediaIdNotFound);
                    media.remove(currentPhoto);
                    SilverLogger.getLogger(MediaDAO.class).warn("Photo not found (removed from result): {0}", new Object[]{mediaIdNotFound});
                }
            }
        }
    }

    private static void decorateVideos(List<Media> media, Map<String, Video> videos) throws SQLException {
        if (!videos.isEmpty()) {
            Collection idGroups = CollectionUtil.split(new ArrayList<String>(videos.keySet()));
            String queryBase = "I.mediaId, I.fileName, I.fileSize, I.fileMimeType, I.download, I.beginDownloadDate, I.endDownloadDate, V.resolutionW, V.resolutionH, V.bitrate, V.duration from SC_Gallery_Internal I join SC_Gallery_Video V on I.mediaId = V.mediaId where I.mediaId";
            for (Collection mediaIds : idGroups) {
                JdbcSqlQuery.createSelect((String)queryBase, (Object[])new Object[0]).in(mediaIds).execute(row -> {
                    String mediaId = row.getString(1);
                    mediaIds.remove(mediaId);
                    Video currentVideo = (Video)videos.get(mediaId);
                    MediaDAO.decorateInternalMedia(row, currentVideo);
                    currentVideo.setDefinition(Definition.of((int)row.getInt(8), (int)row.getInt(9)));
                    currentVideo.setBitrate(row.getLong(10));
                    currentVideo.setDuration(row.getLong(11));
                    return null;
                });
                for (String mediaIdNotFound : mediaIds) {
                    Video currentVideo = videos.remove(mediaIdNotFound);
                    media.remove(currentVideo);
                    SilverLogger.getLogger(MediaDAO.class).warn("Video not found (removed from result): {0}", new Object[]{mediaIdNotFound});
                }
            }
        }
    }

    private static void decorateSounds(List<Media> media, Map<String, Sound> sounds) throws SQLException {
        if (!sounds.isEmpty()) {
            Collection idGroups = CollectionUtil.split(new ArrayList<String>(sounds.keySet()));
            String queryBase = "I.mediaId, I.fileName, I.fileSize, I.fileMimeType, I.download, I.beginDownloadDate, I.endDownloadDate, S.bitrate, S.duration from SC_Gallery_Internal I join SC_Gallery_Sound S on I.mediaId = S.mediaId where I.mediaId";
            for (Collection mediaIds : idGroups) {
                JdbcSqlQuery.createSelect((String)queryBase, (Object[])new Object[0]).in(mediaIds).execute(row -> {
                    String mediaId = row.getString(1);
                    mediaIds.remove(mediaId);
                    Sound currentSound = (Sound)sounds.get(mediaId);
                    MediaDAO.decorateInternalMedia(row, currentSound);
                    currentSound.setBitrate(row.getLong(8));
                    currentSound.setDuration(row.getLong(9));
                    return null;
                });
                for (String mediaIdNotFound : mediaIds) {
                    Sound currentSound = sounds.remove(mediaIdNotFound);
                    media.remove(currentSound);
                    SilverLogger.getLogger(MediaDAO.class).warn("Sound not found (removed from result): {0}", new Object[]{mediaIdNotFound});
                }
            }
        }
    }

    private static void decorateStreamings(List<Media> media, Map<String, Streaming> streamings) throws SQLException {
        if (!streamings.isEmpty()) {
            Collection idGroups = CollectionUtil.split(new ArrayList<String>(streamings.keySet()));
            String queryBase = "S.mediaId, S.homepageUrl, S.provider from SC_Gallery_Streaming S where S.mediaId";
            for (Collection mediaIds : idGroups) {
                JdbcSqlQuery.createSelect((String)queryBase, (Object[])new Object[0]).in(mediaIds).execute(row -> {
                    String mediaId = row.getString(1);
                    mediaIds.remove(mediaId);
                    Streaming currentStreaming = (Streaming)streamings.get(mediaId);
                    currentStreaming.setHomepageUrl(row.getString(2));
                    StreamingProvidersRegistry.get().getByName(row.getString(3)).ifPresent(currentStreaming::setProvider);
                    return null;
                });
                for (String mediaIdNotFound : mediaIds) {
                    Streaming currentStreaming = streamings.remove(mediaIdNotFound);
                    media.remove(currentStreaming);
                    SilverLogger.getLogger(MediaDAO.class).warn("Streaming not found (removed from result): {0}", new Object[]{mediaIdNotFound});
                }
            }
        }
    }

    private static void decorateInternalMedia(ResultSetWrapper rsw, InternalMedia iMedia) throws SQLException {
        iMedia.setFileName(rsw.getString(2));
        iMedia.setFileSize(rsw.getLong(3));
        iMedia.setFileMimeType(MediaMimeType.fromMimeType(rsw.getString(4)));
        iMedia.setDownloadAuthorized(rsw.getInt(5) == 1);
        iMedia.setDownloadPeriod(MediaDAO.getPeriod(rsw));
    }

    public static long countByCriteria(MediaCriteria criteria) throws SQLException {
        MediaSQLQueryBuilder queryBuilder = MediaSQLQueryBuilder.countBuilder();
        criteria.processWith(queryBuilder);
        JdbcSqlQuery selectQuery = queryBuilder.result();
        return (Long)selectQuery.executeUnique(row -> row.getLong(1));
    }

    private static Period getPeriod(ResultSetWrapper rsw) throws SQLException {
        Date end;
        Date begin = rsw.getDateFromLong(6);
        if (begin == null) {
            begin = DateUtil.MINIMUM_DATE;
        }
        if ((end = rsw.getDateFromLong(7)) == null) {
            end = DateUtil.MAXIMUM_DATE;
        }
        return Period.check((Period)Period.from((Date)begin, (Date)end));
    }

    public static String saveMedia(OperationContext context, Media media) throws SQLException {
        boolean isInsert;
        JdbcSqlQueries updateQueries = new JdbcSqlQueries();
        String uuid = media.getId();
        boolean bl = isInsert = !JdbcSqlQuery.isSqlDefined((String)uuid) || JdbcSqlQuery.createCountFor((String)GALLERY_MEDIA_TABLE).where(MEDIA_ID_CRITERIA, new Object[]{uuid}).execute() == 0L;
        if (isInsert) {
            uuid = DBUtil.getUniqueId();
            media.getMediaPK().setId(uuid);
        }
        updateQueries.add((Object)MediaDAO.prepareSaveMedia(context, media, isInsert));
        if (media.getType().isPhoto()) {
            updateQueries.addAll(MediaDAO.prepareSavePhoto(media.getPhoto(), isInsert));
        }
        if (media.getType().isVideo()) {
            updateQueries.addAll(MediaDAO.prepareSaveVideo(media.getVideo(), isInsert));
        }
        if (media.getType().isSound()) {
            updateQueries.addAll(MediaDAO.prepareSaveSound(media.getSound(), isInsert));
        }
        if (media.getType().isStreaming()) {
            updateQueries.add((Object)MediaDAO.prepareSaveStreaming(media.getStreaming(), isInsert));
        }
        updateQueries.execute();
        return uuid;
    }

    private static List<JdbcSqlQuery> prepareSavePhoto(Photo photo, boolean isInsert) {
        JdbcSqlQuery photoSave;
        ArrayList<JdbcSqlQuery> updateQueries = new ArrayList<JdbcSqlQuery>();
        updateQueries.add(MediaDAO.prepareSaveInternalMedia(photo, isInsert));
        if (isInsert) {
            photoSave = JdbcSqlQuery.createInsertFor((String)GALLERY_PHOTO_TABLE);
            photoSave.addInsertParam(MEDIA_ID_PARAM, (Object)photo.getId());
        } else {
            photoSave = JdbcSqlQuery.createUpdateFor((String)GALLERY_PHOTO_TABLE);
        }
        Definition definition = photo.getDefinition();
        photoSave.addSaveParam("resolutionW", (Object)definition.getWidth(), isInsert);
        photoSave.addSaveParam("resolutionH", (Object)definition.getHeight(), isInsert);
        if (!isInsert) {
            photoSave.where(MEDIA_ID_CRITERIA, new Object[]{photo.getId()});
        }
        updateQueries.add(photoSave);
        return updateQueries;
    }

    private static List<JdbcSqlQuery> prepareSaveVideo(Video video, boolean isInsert) {
        JdbcSqlQuery videoSave;
        ArrayList<JdbcSqlQuery> updateQueries = new ArrayList<JdbcSqlQuery>();
        updateQueries.add(MediaDAO.prepareSaveInternalMedia(video, isInsert));
        if (isInsert) {
            videoSave = JdbcSqlQuery.createInsertFor((String)GALLERY_VIDEO_TABLE);
            videoSave.addInsertParam(MEDIA_ID_PARAM, (Object)video.getId());
        } else {
            videoSave = JdbcSqlQuery.createUpdateFor((String)GALLERY_VIDEO_TABLE);
        }
        Definition definition = video.getDefinition();
        videoSave.addSaveParam("resolutionW", (Object)definition.getWidth(), isInsert);
        videoSave.addSaveParam("resolutionH", (Object)definition.getHeight(), isInsert);
        videoSave.addSaveParam("bitrate", (Object)video.getBitrate(), isInsert);
        videoSave.addSaveParam("duration", (Object)video.getDuration(), isInsert);
        if (!isInsert) {
            videoSave.where(MEDIA_ID_CRITERIA, new Object[]{video.getId()});
        }
        updateQueries.add(videoSave);
        return updateQueries;
    }

    private static List<JdbcSqlQuery> prepareSaveSound(Sound sound, boolean isInsert) {
        JdbcSqlQuery soundSave;
        ArrayList<JdbcSqlQuery> updateQueries = new ArrayList<JdbcSqlQuery>();
        updateQueries.add(MediaDAO.prepareSaveInternalMedia(sound, isInsert));
        if (isInsert) {
            soundSave = JdbcSqlQuery.createInsertFor((String)GALLERY_SOUND_TABLE);
            soundSave.addInsertParam(MEDIA_ID_PARAM, (Object)sound.getId());
        } else {
            soundSave = JdbcSqlQuery.createUpdateFor((String)GALLERY_SOUND_TABLE);
        }
        soundSave.addSaveParam("bitrate", (Object)sound.getBitrate(), isInsert);
        soundSave.addSaveParam("duration", (Object)sound.getDuration(), isInsert);
        if (!isInsert) {
            soundSave.where(MEDIA_ID_CRITERIA, new Object[]{sound.getId()});
        }
        updateQueries.add(soundSave);
        return updateQueries;
    }

    private static JdbcSqlQuery prepareSaveStreaming(Streaming streaming, boolean isInsert) {
        JdbcSqlQuery streamingSave;
        if (isInsert) {
            streamingSave = JdbcSqlQuery.createInsertFor((String)GALLERY_STREAMING_TABLE);
            streamingSave.addInsertParam(MEDIA_ID_PARAM, (Object)streaming.getId());
        } else {
            streamingSave = JdbcSqlQuery.createUpdateFor((String)GALLERY_STREAMING_TABLE);
        }
        streamingSave.addSaveParam("homepageUrl", (Object)streaming.getHomepageUrl(), isInsert);
        streamingSave.addSaveParam("provider", (Object)streaming.getProvider().map(StreamingProvider::getName).orElseThrow(() -> new IllegalArgumentException("Provider MUST exists")), isInsert);
        if (!isInsert) {
            streamingSave.where(MEDIA_ID_CRITERIA, new Object[]{streaming.getId()});
        }
        return streamingSave;
    }

    private static JdbcSqlQuery prepareSaveMedia(OperationContext context, Media media, boolean isInsert) {
        JdbcSqlQuery mediaSave;
        if (isInsert) {
            mediaSave = JdbcSqlQuery.createInsertFor((String)GALLERY_MEDIA_TABLE);
            mediaSave.addInsertParam(MEDIA_ID_PARAM, (Object)media.getId());
        } else {
            mediaSave = JdbcSqlQuery.createUpdateFor((String)GALLERY_MEDIA_TABLE);
        }
        mediaSave.addSaveParam("mediaType", (Object)media.getType(), isInsert);
        mediaSave.addSaveParam(INSTANCE_ID_PARAM, (Object)media.getInstanceId(), isInsert);
        mediaSave.addSaveParam("title", (Object)media.getTitle(), isInsert);
        mediaSave.addSaveParam("description", (Object)media.getDescription(), isInsert);
        mediaSave.addSaveParam("author", (Object)media.getAuthor(), isInsert);
        mediaSave.addSaveParam("keyword", (Object)media.getKeyWord(), isInsert);
        mediaSave.addSaveParam("beginVisibilityDate", (Object)media.getVisibilityPeriod().getBeginDate().getTime(), isInsert);
        mediaSave.addSaveParam("endVisibilityDate", (Object)media.getVisibilityPeriod().getEndDate().getTime(), isInsert);
        Timestamp saveDate = new Timestamp(new Date().getTime());
        if (isInsert) {
            media.setCreationDate(saveDate);
            media.setCreator(context.getUser());
            media.setLastUpdateDate(saveDate);
            media.setLastUpdater(context.getUser());
            mediaSave.addInsertParam("createDate", (Object)media.getCreationDate());
            mediaSave.addInsertParam("createdBy", (Object)media.getCreatorId());
            mediaSave.addInsertParam("lastUpdateDate", (Object)media.getLastUpdateDate());
            mediaSave.addInsertParam("lastUpdatedBy", (Object)media.getLastUpdatedBy());
        } else if (!context.isUpdatingInCaseOfCreation()) {
            media.setLastUpdateDate(saveDate);
            media.setLastUpdater(context.getUser());
            mediaSave.addUpdateParam("lastUpdateDate", (Object)media.getLastUpdateDate());
            mediaSave.addUpdateParam("lastUpdatedBy", (Object)media.getLastUpdatedBy());
        }
        if (!isInsert) {
            mediaSave.where(MEDIA_ID_CRITERIA, new Object[]{media.getId()});
        }
        return mediaSave;
    }

    private static JdbcSqlQuery prepareSaveInternalMedia(InternalMedia iMedia, boolean isInsert) {
        JdbcSqlQuery iMediaSave;
        if (isInsert) {
            iMediaSave = JdbcSqlQuery.createInsertFor((String)GALLERY_INTERNAL_TABLE);
            iMediaSave.addInsertParam(MEDIA_ID_PARAM, (Object)iMedia.getId());
        } else {
            iMediaSave = JdbcSqlQuery.createUpdateFor((String)GALLERY_INTERNAL_TABLE);
        }
        iMediaSave.addSaveParam("fileName", (Object)iMedia.getFileName(), isInsert);
        iMediaSave.addSaveParam("fileSize", (Object)iMedia.getFileSize(), isInsert);
        iMediaSave.addSaveParam("fileMimeType", (Object)iMedia.getFileMimeType().getMimeType(), isInsert);
        iMediaSave.addSaveParam("download", (Object)(iMedia.isDownloadAuthorized() ? 1 : 0), isInsert);
        Long beginDate = iMedia.getDownloadPeriod().getBeginDatable().isDefined() ? Long.valueOf(iMedia.getDownloadPeriod().getBeginDate().getTime()) : null;
        iMediaSave.addSaveParam("beginDownloadDate", (Object)beginDate, isInsert);
        Long endDate = iMedia.getDownloadPeriod().getEndDatable().isDefined() ? Long.valueOf(iMedia.getDownloadPeriod().getEndDate().getTime()) : null;
        iMediaSave.addSaveParam("endDownloadDate", (Object)endDate, isInsert);
        if (!isInsert) {
            iMediaSave.where(MEDIA_ID_CRITERIA, new Object[]{iMedia.getId()});
        }
        return iMediaSave;
    }

    public static void deleteMedia(Media media) throws SQLException {
        String mediaId = media.getId();
        JdbcSqlQueries updateQueries = new JdbcSqlQueries();
        updateQueries.add((Object)JdbcSqlQuery.createDeleteFor((String)GALLERY_MEDIA_TABLE).where(MEDIA_ID_CRITERIA, new Object[]{mediaId}));
        if (MediaType.Photo == media.getType() || MediaType.Video == media.getType() || MediaType.Sound == media.getType()) {
            updateQueries.add((Object)JdbcSqlQuery.createDeleteFor((String)GALLERY_INTERNAL_TABLE).where(MEDIA_ID_CRITERIA, new Object[]{mediaId}));
        }
        switch (media.getType()) {
            case Photo: {
                updateQueries.add((Object)JdbcSqlQuery.createDeleteFor((String)GALLERY_PHOTO_TABLE).where(MEDIA_ID_CRITERIA, new Object[]{mediaId}));
                break;
            }
            case Video: {
                updateQueries.add((Object)JdbcSqlQuery.createDeleteFor((String)GALLERY_VIDEO_TABLE).where(MEDIA_ID_CRITERIA, new Object[]{mediaId}));
                break;
            }
            case Sound: {
                updateQueries.add((Object)JdbcSqlQuery.createDeleteFor((String)GALLERY_SOUND_TABLE).where(MEDIA_ID_CRITERIA, new Object[]{mediaId}));
                break;
            }
            case Streaming: {
                updateQueries.add((Object)JdbcSqlQuery.createDeleteFor((String)GALLERY_STREAMING_TABLE).where(MEDIA_ID_CRITERIA, new Object[]{mediaId}));
                break;
            }
            default: {
                SilverLogger.getLogger(MediaDAO.class).warn("Unknown media type: {0}", new Object[]{media.getId()});
            }
        }
        updateQueries.execute();
        MediaDAO.deleteAllMediaPath(media);
    }

    public static void saveMediaPath(Media media, String albumId) throws SQLException {
        boolean isInsert;
        List<Serializable> pathParams = Arrays.asList(media.getId(), media.getInstanceId(), Integer.valueOf(albumId));
        boolean bl = isInsert = JdbcSqlQuery.createCountFor((String)GALLERY_PATH_TABLE).where("mediaId = ? and instanceId = ? and nodeId = ?", pathParams).execute() == 0L;
        if (isInsert) {
            Iterator<Serializable> paramIt = pathParams.iterator();
            JdbcSqlQuery insert = JdbcSqlQuery.createInsertFor((String)GALLERY_PATH_TABLE);
            insert.addInsertParam(MEDIA_ID_PARAM, (Object)paramIt.next());
            insert.addInsertParam(INSTANCE_ID_PARAM, (Object)paramIt.next());
            insert.addInsertParam("nodeId", (Object)paramIt.next());
            insert.execute();
        }
    }

    public static void deleteAllMediaPath(Media media) throws SQLException {
        JdbcSqlQuery.createDeleteFor((String)GALLERY_PATH_TABLE).where("mediaId = ? and instanceId = ?", new Object[]{media.getId(), media.getInstanceId()}).execute();
    }

    public static Collection<String> getAlbumIdsOf(Media media) throws SQLException {
        return JdbcSqlQuery.createSelect((String)"N.NodeId from SC_Gallery_Path P, SB_Node_Node N where P.mediaId = ? and N.nodeId = P.NodeId and P.instanceId = ? and N.instanceId = P.instanceId", (Object[])new Object[]{media.getId(), media.getInstanceId()}).execute(row -> String.valueOf(row.getInt(1)));
    }

    public static List<SocialInformation> getAllMediaIdByUserId(String userId, Period period) throws SQLException {
        return JdbcSqlQuery.create((String)"(select createDate AS dateinformation, mediaId, 'new' as type from SC_Gallery_Media where createdBy = ? and createDate >= ? and createDate <= ? ) union (select lastUpdateDate AS dateinformation, mediaId , 'update' as type from SC_Gallery_Media where lastUpdatedBy = ? and lastUpdateDate <> createDate and lastUpdateDate >= ? and lastUpdateDate <= ? ) order by dateinformation desc, mediaId desc", (Object[])new Object[]{userId, period.getBeginDatable(), period.getEndDatable(), userId, period.getBeginDatable(), period.getEndDatable()}).execute(row -> {
            Media media = MediaDAO.getByCriteria(MediaCriteria.fromMediaId(row.getString(2)).withVisibility(MediaCriteria.VISIBILITY.FORCE_GET_ALL));
            MediaWithStatus withStatus = new MediaWithStatus(media, "update".equalsIgnoreCase(row.getString(3)));
            return new SocialInformationGallery(withStatus);
        });
    }

    public static List<SocialInformation> getSocialInformationListOfMyContacts(List<String> userIds, List<String> availableComponents, Period period) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.create((String)"(select createDate as dateinformation, mediaId, 'new' as type", (Object[])new Object[0]);
        query.addSqlPart("from SC_Gallery_Media where createdBy", new Object[0]).in(userIds);
        query.and(INSTANCE_ID_PARAM, new Object[0]).in(availableComponents);
        query.and("createDate >= ? and createDate <= ?)", new Object[]{period.getBeginDatable(), period.getEndDatable()});
        query.addSqlPart("union (select lastUpdateDate as dateinformation, mediaId, 'update' as type", new Object[0]);
        query.addSqlPart("from SC_Gallery_Media where lastUpdatedBy", new Object[0]).in(userIds);
        query.and(INSTANCE_ID_PARAM, new Object[0]).in(availableComponents);
        query.and("lastUpdateDate <> createDate", new Object[0]);
        query.and("lastUpdateDate >= ? and lastUpdateDate <= ?)", new Object[]{period.getBeginDatable(), period.getEndDatable()});
        query.addSqlPart("order by dateinformation desc, mediaId desc", new Object[0]);
        return query.execute(row -> {
            Media media = MediaDAO.getByCriteria(MediaCriteria.fromMediaId(row.getString(2)).withVisibility(MediaCriteria.VISIBILITY.FORCE_GET_ALL));
            MediaWithStatus withStatus = new MediaWithStatus(media, "update".equalsIgnoreCase(row.getString(3)));
            return new SocialInformationGallery(withStatus);
        });
    }

    private static class MediaInfo {
        private final String mediaId;
        private final MediaType mediaType;
        private final String instanceId;

        public MediaInfo(String mediaId, MediaType mediaType, String instanceId) {
            this.mediaId = mediaId;
            this.mediaType = mediaType;
            this.instanceId = instanceId;
        }

        public String getMediaId() {
            return this.mediaId;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public String getInstanceId() {
            return this.instanceId;
        }
    }
}

